package io.typeflows.gradle

import org.gradle.api.file.ConfigurableFileCollection
import java.net.URLClassLoader

object ClasspathExecutor {
    fun <T> withClasspath(classpath: ConfigurableFileCollection, block: (URLClassLoader) -> T): T {
        val urls = classpath.files.map { it.toURI().toURL() }.toTypedArray()
        val classLoader = URLClassLoader(urls, ClasspathExecutor::class.java.classLoader)

        val originalClassLoader = Thread.currentThread().contextClassLoader
        Thread.currentThread().contextClassLoader = classLoader
        try {
            return block(classLoader)
        } finally {
            Thread.currentThread().contextClassLoader = originalClassLoader
        }
    }
}