/*
 * Copyright (c) 2025 Incerto Group Ltd
 * This is beta software under the Typeflows Beta License.
 * See LICENSE file for details.
 *
 * For more information, visit https://typeflows.io/license
 */

package io.typeflows.gradle.tasks

import io.typeflows.plugin.TypeflowsRunner
import io.typeflows.plugin.tasks.InstallClaude
import org.gradle.api.DefaultTask
import org.gradle.api.file.ConfigurableFileCollection
import org.gradle.api.file.DirectoryProperty
import org.gradle.api.tasks.InputFiles
import org.gradle.api.tasks.OutputDirectory
import org.gradle.api.tasks.PathSensitive
import org.gradle.api.tasks.PathSensitivity.RELATIVE
import org.gradle.api.tasks.TaskAction

abstract class InstallClaudeTask : DefaultTask() {
    @get:InputFiles
    @get:PathSensitive(RELATIVE)
    abstract val classpath: ConfigurableFileCollection

    @get:OutputDirectory
    abstract val targetDirectory: DirectoryProperty

    @TaskAction
    fun typeflowsInstallClaude() {
        TypeflowsRunner.execute(
            classpathElements = classpath.files.map { it.absolutePath },
            typeflowsClassName = InstallClaude::class.qualifiedName!!,
            outputDirectory = targetDirectory.get().asFile,
            onSuccess = { logger.lifecycle("✅ Claude commands installed") },
            onFailure = { exception -> logger.lifecycle("❌ Failed to install Claude commands (${exception.javaClass.simpleName}): ${exception.message}") }
        )
    }
}
