/*
 * Decompiled with CFR 0.152.
 */
package io.typeflows.gradle.tasks;

import io.typeflows.gradle.ClasspathExecutor;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH%J\b\u0010\n\u001a\u00020\u000bH\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH$R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lio/typeflows/gradle/tasks/InstallTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "getTargetDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "executeInstall", "", "extractFromPluginClasspath", "", "outputDir", "Ljava/io/File;", "extractFromJar", "jarFile", "processExtractedFiles", "logSuccess", "typeflows-github-gradle"})
@SourceDebugExtension(value={"SMAP\nInstallTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallTask.kt\nio/typeflows/gradle/tasks/InstallTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1#2:87\n1869#3,2:88\n774#3:90\n865#3,2:91\n1869#3,2:93\n*S KotlinDebug\n*F\n+ 1 InstallTask.kt\nio/typeflows/gradle/tasks/InstallTask\n*L\n67#1:88,2\n31#1:90\n31#1:91,2\n32#1:93,2\n*E\n"})
public abstract class InstallTask
extends DefaultTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getClasspath();

    @Internal
    @NotNull
    protected abstract DirectoryProperty getTargetDirectory();

    protected final void executeInstall() {
        File file;
        File $this$executeInstall_u24lambda_u240 = file = ((Directory)this.getTargetDirectory().get()).getAsFile();
        boolean bl = false;
        $this$executeInstall_u24lambda_u240.mkdirs();
        File file2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"apply(...)");
        File targetDir = file2;
        ClasspathExecutor.INSTANCE.withClasspath(this.getClasspath(), arg_0 -> InstallTask.executeInstall$lambda$3(this, targetDir, arg_0));
    }

    protected boolean extractFromPluginClasspath(@NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        ClassLoader pluginClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        URL instructionsResource = pluginClassLoader.getResource("llm");
        if (instructionsResource != null && Intrinsics.areEqual((Object)instructionsResource.getProtocol(), (Object)"jar")) {
            String string = instructionsResource.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String jarPath = StringsKt.substringBefore$default((String)string, (String)"!/llm", null, (int)2, null);
            if (StringsKt.startsWith$default((String)jarPath, (String)"file:", (boolean)false, (int)2, null)) {
                return this.extractFromJar(new File(StringsKt.removePrefix((String)jarPath, (CharSequence)"file:")), outputDir);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean extractFromJar(@NotNull File jarFile, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        boolean extracted = false;
        Closeable closeable = new JarFile(jarFile);
        Throwable throwable = null;
        try {
            JarFile jar = (JarFile)closeable;
            boolean bl = false;
            Enumeration<JarEntry> enumeration = jar.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            List instructionEntries = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), InstallTask::extractFromJar$lambda$9$lambda$4));
            System.out.println((Object)CollectionsKt.joinToString$default((Iterable)instructionEntries, (CharSequence)", ", null, null, (int)0, null, InstallTask::extractFromJar$lambda$9$lambda$5, (int)30, null));
            if (instructionEntries.isEmpty()) {
                boolean bl2 = false;
                return bl2;
            }
            Iterable $this$forEach$iv = instructionEntries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JarEntry entry = (JarEntry)element$iv;
                boolean bl3 = false;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                File targetFile = new File(outputDir, StringsKt.removePrefix((String)string, (CharSequence)"llm/"));
                File file = targetFile.getParentFile();
                if (file != null) {
                    file.mkdirs();
                }
                Closeable closeable2 = jar.getInputStream(entry);
                Throwable throwable2 = null;
                try {
                    long l;
                    InputStream input = (InputStream)closeable2;
                    boolean bl4 = false;
                    Closeable closeable3 = new FileOutputStream(targetFile);
                    Throwable throwable3 = null;
                    try {
                        FileOutputStream output = (FileOutputStream)closeable3;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)input);
                        l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                extracted = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return extracted;
    }

    protected abstract void processExtractedFiles(@NotNull File var1);

    protected abstract void logSuccess(@NotNull File var1);

    /*
     * WARNING - void declaration
     */
    private static final Unit executeInstall$lambda$3(InstallTask this$0, File $targetDir, URLClassLoader classLoader) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        boolean extracted = false;
        extracted = this$0.extractFromPluginClasspath($targetDir);
        Set set = this$0.getClasspath().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        Iterable iterable = set;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"jar")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)file);
            extracted = this$0.extractFromJar(file, $targetDir) || extracted;
        }
        if (extracted) {
            this$0.processExtractedFiles($targetDir);
            this$0.logSuccess($targetDir);
        } else {
            this$0.getLogger().lifecycle("\u001b[33m\u26a0\ufe0f No LLM instructions found\u001b[0m");
        }
        return Unit.INSTANCE;
    }

    private static final boolean extractFromJar$lambda$9$lambda$4(JarEntry it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)"llm/", (boolean)false, (int)2, null) && !it.isDirectory();
    }

    private static final CharSequence extractFromJar$lambda$9$lambda$5(JarEntry it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

