/*
 * Decompiled with CFR 0.152.
 */
package io.typeflows.gradle.tasks;

import io.typeflows.gradle.tasks.InstallTask;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u0005H\u0014J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lio/typeflows/gradle/tasks/InstallCopilotTask;", "Lio/typeflows/gradle/tasks/InstallTask;", "<init>", "()V", "copilotDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getCopilotDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "typeflowsInstallCopilot", "", "getTargetDirectory", "processExtractedFiles", "outputDir", "Ljava/io/File;", "transformToInstructionFile", "sourceFile", "instructionsDir", "transformToPromptFile", "promptsDir", "transformContentForInstructions", "", "content", "transformContentForPrompts", "logSuccess", "typeflows-github-gradle"})
@SourceDebugExtension(value={"SMAP\nInstallCopilotTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallCopilotTask.kt\nio/typeflows/gradle/tasks/InstallCopilotTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,95:1\n1#2:96\n13472#3,2:97\n*S KotlinDebug\n*F\n+ 1 InstallCopilotTask.kt\nio/typeflows/gradle/tasks/InstallCopilotTask\n*L\n23#1:97,2\n*E\n"})
public abstract class InstallCopilotTask
extends InstallTask {
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getCopilotDirectory();

    @TaskAction
    public final void typeflowsInstallCopilot() {
        this.executeInstall();
    }

    @Override
    @NotNull
    protected DirectoryProperty getTargetDirectory() {
        return this.getCopilotDirectory();
    }

    @Override
    protected void processExtractedFiles(@NotNull File outputDir) {
        block5: {
            File file;
            File file2;
            Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
            File $this$processExtractedFiles_u24lambda_u240 = file2 = new File(outputDir.getParent(), ".github/instructions");
            boolean bl = false;
            $this$processExtractedFiles_u24lambda_u240.mkdirs();
            File instructionsDir = file2;
            File $this$processExtractedFiles_u24lambda_u241 = file = new File(outputDir.getParent(), ".github/prompts");
            boolean bl2 = false;
            $this$processExtractedFiles_u24lambda_u241.mkdirs();
            File promptsDir = file;
            File[] fileArray = outputDir.listFiles(InstallCopilotTask::processExtractedFiles$lambda$2);
            if (fileArray == null) break block5;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[j];
                boolean bl3 = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"import", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNull((Object)it);
                    this.transformToInstructionFile(it, instructionsDir);
                } else {
                    String string2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"doctor", (boolean)false, (int)2, null)) {
                        Intrinsics.checkNotNull((Object)it);
                        this.transformToPromptFile(it, promptsDir);
                    } else {
                        Intrinsics.checkNotNull((Object)it);
                        this.transformToInstructionFile(it, instructionsDir);
                    }
                }
                it.delete();
            }
        }
    }

    private final void transformToInstructionFile(File sourceFile, File instructionsDir) {
        String content = FilesKt.readText$default((File)sourceFile, null, (int)1, null);
        String transformedContent = this.transformContentForInstructions(content);
        FilesKt.writeText$default((File)new File(instructionsDir, "typeflows-" + FilesKt.getNameWithoutExtension((File)sourceFile) + ".instructions.md"), (String)transformedContent, null, (int)2, null);
    }

    private final void transformToPromptFile(File sourceFile, File promptsDir) {
        String content = FilesKt.readText$default((File)sourceFile, null, (int)1, null);
        String transformedContent = this.transformContentForPrompts(content);
        File targetFile = new File(promptsDir, "typeflows-" + FilesKt.getNameWithoutExtension((File)sourceFile) + ".prompt.md");
        FilesKt.writeText$default((File)targetFile, (String)transformedContent, null, (int)2, null);
    }

    private final String transformContentForInstructions(String content) {
        return "---\ndescription: Typeflows GitHub Actions conversion instructions for Kotlin/Java workflow builders\nglobs:\n  - \"**/*.kt\"\n  - \"**/*.java\"\n  - \"src/main/kotlin/**/*\"\n  - \"src/main/java/**/*\"\n  - \".github/workflows/**/*.yml\"\n  - \".github/workflows/**/*.yaml\"\nauthor: Typeflows\nversion: 1.0\n---\n\n# Typeflows Instructions\n\n" + content + "\n\n## Usage in Copilot\nThese instructions help GitHub Copilot understand how to work with Typeflows for GitHub Actions workflow generation.\n";
    }

    private final String transformContentForPrompts(String content) {
        return "---\nmode: 'agent'\ndescription: Typeflows analysis and optimization prompt for GitHub Actions workflows\ntools:\n  - 'codebase'\n  - 'githubRepo'\nauthor: Typeflows\nversion: 1.0\n---\n\n" + content + "\n\n## Prompt Usage\nUse this prompt template for analyzing and improving Typeflows-generated workflows.\n";
    }

    @Override
    protected void logSuccess(@NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        this.getLogger().lifecycle("\u001b[32m\u2705 Copilot instructions installed:\u001b[0m \u001b[36m.github/instructions/ and .github/prompts/\u001b[0m");
    }

    private static final boolean processExtractedFiles$lambda$2(File it) {
        Intrinsics.checkNotNull((Object)it);
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"md");
    }
}

