package io.typeflows.gradle.download

import dev.forkhandles.result4k.Failure
import dev.forkhandles.result4k.Result4k
import dev.forkhandles.result4k.resultFrom
import io.typeflows.github.format.Yaml.yaml
import org.http4k.client.JavaHttpClient
import org.http4k.cloudnative.RemoteRequestFailed
import org.http4k.core.HttpHandler
import org.http4k.core.Method.GET
import org.http4k.core.Request

class GitHub(private val http: HttpHandler = JavaHttpClient()) {
    fun downloadAction(action: Action): Result4k<ActionDefinition, Exception> {
        val response = http(
            Request(
                GET,
                "https://raw.githubusercontent.com/actions/${action.name}/refs/tags/${action.version}/action.yml"
            )
        )

        return when {
            response.status.successful -> resultFrom { response.yaml<ActionDefinition>() }
            else -> Failure(RemoteRequestFailed(response.status, "Failed to download action due to ${response.status}"))
        }
    }
}
