package io.typeflows.gradle

import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.plugins.JavaPluginExtension
import org.gradle.kotlin.dsl.create
import org.gradle.kotlin.dsl.register
import org.gradle.kotlin.dsl.the

class TypeflowsPlugin : Plugin<Project> {
    override fun apply(project: Project) {
        val extension = project.extensions.create<TypeflowsExtension>("typeflows").apply {
            outputDir.convention(project.layout.projectDirectory.dir(".github/workflows"))
            fileNamePattern.convention("{name}.yml")
        }

        project.plugins.withId("java") {
            project.the<JavaPluginExtension>().sourceSets.create("typeflows")
            project.tasks.register<ExportWorkflowsTask>("exportWorkflows") {
                group = "typeflows"
                description = "Export WorkflowBuilder implementations to YAML files"

                outputDir.set(extension.outputDir)
                fileNamePattern.set(extension.fileNamePattern)

                val javaExt = project.the<JavaPluginExtension>()
                val typeflowsSourceSet = javaExt.sourceSets.getByName("typeflows")

                scanDirectories.from(typeflowsSourceSet.output.classesDirs)
                classpath.from(typeflowsSourceSet.runtimeClasspath)
                dependsOn("typeflowsClasses")
            }
            project.tasks.named("assemble") {
                it.dependsOn("exportWorkflows")
            }
        }
    }

}
