/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Optional;

public class RecordAutoDetectModule
extends SimpleModule {
    private static final Optional<MethodHandle> IS_RECORD;

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.insertAnnotationIntrospector((AnnotationIntrospector)new Introspector());
    }

    private static boolean isRecord(AnnotatedClass ac, MethodHandle methodHandle) {
        try {
            return methodHandle.invokeExact(ac.getRawType());
        }
        catch (Throwable e) {
            return false;
        }
    }

    static {
        MethodHandle methodHandle;
        try {
            methodHandle = MethodHandles.lookup().findVirtual(Class.class, "isRecord", MethodType.methodType(Boolean.TYPE));
        }
        catch (Exception e) {
            methodHandle = null;
        }
        IS_RECORD = Optional.ofNullable(methodHandle);
    }

    private static class Introspector
    extends AnnotationIntrospector {
        private static final VisibilityChecker.Std RECORD_VISIBILITY_CHECKER = VisibilityChecker.Std.defaultInstance().withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withCreatorVisibility(JsonAutoDetect.Visibility.DEFAULT).withFieldVisibility(JsonAutoDetect.Visibility.DEFAULT).withIsGetterVisibility(JsonAutoDetect.Visibility.DEFAULT);

        private Introspector() {
        }

        public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
            if (IS_RECORD.map(methodHandle -> RecordAutoDetectModule.isRecord(ac, methodHandle)).orElse(false).booleanValue()) {
                JsonAutoDetect overrideAnnotation = ac.getRawType().getAnnotation(JsonAutoDetect.class);
                if (overrideAnnotation != null) {
                    return VisibilityChecker.Std.construct((JsonAutoDetect.Value)JsonAutoDetect.Value.from((JsonAutoDetect)overrideAnnotation));
                }
                return RECORD_VISIBILITY_CHECKER;
            }
            return checker;
        }

        public Version version() {
            return Version.unknownVersion();
        }
    }
}

