/*
 * Decompiled with CFR 0.152.
 */
package io.trino.collect.cache;

import com.google.common.cache.ForwardingLoadingCache;
import com.google.common.cache.LoadingCache;
import io.trino.collect.cache.NonKeyEvictableLoadingCache;
import java.util.Objects;

class NonKeyEvictableLoadingCacheImpl<K, V>
extends ForwardingLoadingCache<K, V>
implements NonKeyEvictableLoadingCache<K, V> {
    private final LoadingCache<K, V> delegate;

    NonKeyEvictableLoadingCacheImpl(LoadingCache<K, V> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    protected LoadingCache<K, V> delegate() {
        return this.delegate;
    }

    @Override
    public void invalidate(Object key) {
        throw new UnsupportedOperationException("invalidate(key) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
    }

    @Override
    public void invalidateAll(Iterable<?> keys) {
        throw new UnsupportedOperationException("invalidateAll(keys) does not invalidate ongoing loads, so a stale value may remain in the cache for ever. Use EvictableCacheBuilder if you need invalidation");
    }
}

