/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import io.airlift.units.Duration;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.trino.plugin.kafka.KafkaConfig;
import io.trino.plugin.kafka.KafkaErrorCode;
import io.trino.plugin.kafka.KafkaTopicDescription;
import io.trino.plugin.kafka.KafkaTopicFieldGroup;
import io.trino.plugin.kafka.schema.TableDescriptionSupplier;
import io.trino.plugin.kafka.schema.confluent.ConfluentSchemaRegistryConfig;
import io.trino.plugin.kafka.schema.confluent.SchemaParser;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;

public class ConfluentSchemaRegistryTableDescriptionSupplier
implements TableDescriptionSupplier {
    public static final String NAME = "confluent";
    private static final String KEY_VALUE_PAIR_DELIMITER = "&";
    private static final String KEY_VALUE_DELIMITER = "=";
    private static final String KEY_SUBJECT = "key-subject";
    private static final String VALUE_SUBJECT = "value-subject";
    private static final String KEY_SUFFIX = "-key";
    private static final String VALUE_SUFFIX = "-value";
    private final SchemaRegistryClient schemaRegistryClient;
    private final Map<String, SchemaParser> schemaParsers;
    private final String defaultSchema;
    private final Supplier<SetMultimap<String, TopicAndSubjects>> topicAndSubjectsSupplier;
    private final Supplier<SetMultimap<String, String>> subjectsSupplier;

    public ConfluentSchemaRegistryTableDescriptionSupplier(SchemaRegistryClient schemaRegistryClient, Map<String, SchemaParser> schemaParsers, String defaultSchema, Duration subjectsCacheRefreshInterval) {
        this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "schemaRegistryClient is null");
        this.schemaParsers = ImmutableMap.copyOf(Objects.requireNonNull(schemaParsers, "schemaParsers is null"));
        this.defaultSchema = Objects.requireNonNull(defaultSchema, "defaultSchema is null");
        this.topicAndSubjectsSupplier = Suppliers.memoizeWithExpiration(this::getTopicAndSubjects, (long)subjectsCacheRefreshInterval.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.subjectsSupplier = Suppliers.memoizeWithExpiration(this::getAllSubjects, (long)subjectsCacheRefreshInterval.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private String resolveSubject(String candidate) {
        Set subjects = this.subjectsSupplier.get().get((Object)candidate);
        Preconditions.checkState((!subjects.isEmpty() ? 1 : 0) != 0, (String)"Subject '%s' not found", (Object)candidate);
        if (subjects.size() != 1) {
            throw new TrinoException((ErrorCodeSupplier)KafkaErrorCode.SCHEMA_REGISTRY_AMBIGUOUS_SUBJECT, String.format("Subject '%s' is ambiguous, and may refer to one of the following: %s", candidate, String.join((CharSequence)", ", subjects)));
        }
        return (String)Iterables.getOnlyElement((Iterable)subjects);
    }

    private SetMultimap<String, String> getAllSubjects() {
        try {
            return (SetMultimap)this.schemaRegistryClient.getAllSubjects().stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(subject -> subject.toLowerCase(Locale.ENGLISH), UnaryOperator.identity()));
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException("Failed to retrieve subjects from schema registry", e);
        }
    }

    private SetMultimap<String, TopicAndSubjects> getTopicAndSubjects() {
        ImmutableSetMultimap.Builder topicToSubjectsBuilder = ImmutableSetMultimap.builder();
        for (String subject : this.subjectsSupplier.get().values()) {
            if (!ConfluentSchemaRegistryTableDescriptionSupplier.isValidSubject(subject)) continue;
            topicToSubjectsBuilder.put((Object)ConfluentSchemaRegistryTableDescriptionSupplier.extractTopicFromSubject(subject), (Object)subject);
        }
        ImmutableSetMultimap.Builder topicSubjectsCacheBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry entry : topicToSubjectsBuilder.build().asMap().entrySet()) {
            String topic = (String)entry.getKey();
            TopicAndSubjects topicAndSubjects = new TopicAndSubjects(topic, ConfluentSchemaRegistryTableDescriptionSupplier.getKeySubjectFromTopic(topic, (Collection)entry.getValue()), ConfluentSchemaRegistryTableDescriptionSupplier.getValueSubjectFromTopic(topic, (Collection)entry.getValue()));
            topicSubjectsCacheBuilder.put((Object)topicAndSubjects.getTableName(), (Object)topicAndSubjects);
        }
        return topicSubjectsCacheBuilder.build();
    }

    @Override
    public Optional<KafkaTopicDescription> getTopicDescription(ConnectorSession session, SchemaTableName schemaTableName) {
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        TopicAndSubjects topicAndSubjects = this.parseTopicAndSubjects(schemaTableName);
        String tableName = topicAndSubjects.getTableName();
        if (this.topicAndSubjectsSupplier.get().containsKey((Object)tableName)) {
            Set topicAndSubjectsCollection = this.topicAndSubjectsSupplier.get().get((Object)tableName);
            if (topicAndSubjectsCollection.size() != 1) {
                throw new TrinoException((ErrorCodeSupplier)KafkaErrorCode.SCHEMA_REGISTRY_AMBIGUOUS_SUBJECT, String.format("Unable to access '%s' table. Subject is ambiguous, and may refer to one of the following: %s", schemaTableName.getTableName(), topicAndSubjectsCollection.stream().map(TopicAndSubjects::getTopic).collect(Collectors.joining(", "))));
            }
            TopicAndSubjects topicAndSubjectsFromCache = (TopicAndSubjects)Iterables.getOnlyElement((Iterable)topicAndSubjectsCollection);
            topicAndSubjects = new TopicAndSubjects(topicAndSubjectsFromCache.getTopic(), topicAndSubjects.getKeySubject().or(topicAndSubjectsFromCache::getKeySubject), topicAndSubjects.getValueSubject().or(topicAndSubjectsFromCache::getValueSubject));
        }
        if (topicAndSubjects.getKeySubject().isEmpty() && topicAndSubjects.getValueSubject().isEmpty()) {
            return Optional.empty();
        }
        Optional<KafkaTopicFieldGroup> key = topicAndSubjects.getKeySubject().map(subject -> this.getFieldGroup(session, (String)subject));
        Optional<KafkaTopicFieldGroup> message = topicAndSubjects.getValueSubject().map(subject -> this.getFieldGroup(session, (String)subject));
        return Optional.of(new KafkaTopicDescription(tableName, Optional.of(schemaTableName.getSchemaName()), topicAndSubjects.getTopic(), key, message));
    }

    private KafkaTopicFieldGroup getFieldGroup(ConnectorSession session, String subject) {
        SchemaMetadata schemaMetadata = this.getLatestSchemaMetadata(subject);
        SchemaParser schemaParser = this.schemaParsers.get(schemaMetadata.getSchemaType());
        if (schemaParser == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Not supported schema: " + schemaMetadata.getSchemaType());
        }
        return schemaParser.parse(session, subject, (ParsedSchema)this.schemaRegistryClient.parseSchema(schemaMetadata.getSchemaType(), schemaMetadata.getSchema(), schemaMetadata.getReferences()).orElseThrow());
    }

    private SchemaMetadata getLatestSchemaMetadata(String subject) {
        try {
            return this.schemaRegistryClient.getLatestSchemaMetadata(subject);
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(String.format("Unable to get field group for '%s' subject", subject), e);
        }
    }

    private TopicAndSubjects parseTopicAndSubjects(SchemaTableName encodedSchemaTableName) {
        String encodedTableName = encodedSchemaTableName.getTableName();
        List parts = Splitter.on((String)KEY_VALUE_PAIR_DELIMITER).trimResults().splitToList((CharSequence)encodedTableName);
        Preconditions.checkState((!parts.isEmpty() && parts.size() <= 3 ? 1 : 0) != 0, (Object)"Unexpected format for encodedTableName. Expected format is <tableName>[&key-subject=<key subject>][&value-subject=<value subject>]");
        String tableName = (String)parts.get(0);
        Optional<String> keySubject = Optional.empty();
        Optional<String> valueSubject = Optional.empty();
        for (int part = 1; part < parts.size(); ++part) {
            List subjectKeyValue = Splitter.on((String)KEY_VALUE_DELIMITER).trimResults().splitToList((CharSequence)parts.get(part));
            Preconditions.checkState((subjectKeyValue.size() == 2 && (((String)subjectKeyValue.get(0)).equals(KEY_SUBJECT) || ((String)subjectKeyValue.get(0)).equals(VALUE_SUBJECT)) ? 1 : 0) != 0, (String)"Unexpected parameter '%s', should be %s=<key subject>' or %s=<value subject>", parts.get(part), (Object)KEY_SUBJECT, (Object)VALUE_SUBJECT);
            if (((String)subjectKeyValue.get(0)).equals(KEY_SUBJECT)) {
                Preconditions.checkState((boolean)keySubject.isEmpty(), (Object)"Key subject already defined");
                keySubject = Optional.of((String)subjectKeyValue.get(1)).map(this::resolveSubject);
                continue;
            }
            Preconditions.checkState((boolean)valueSubject.isEmpty(), (Object)"Value subject already defined");
            valueSubject = Optional.of((String)subjectKeyValue.get(1)).map(this::resolveSubject);
        }
        return new TopicAndSubjects(tableName, keySubject, valueSubject);
    }

    @Override
    public Set<SchemaTableName> listTables() {
        return (Set)this.topicAndSubjectsSupplier.get().keySet().stream().map(tableName -> new SchemaTableName(this.defaultSchema, tableName)).collect(ImmutableSet.toImmutableSet());
    }

    private static boolean isValidSubject(String subject) {
        Objects.requireNonNull(subject, "subject is null");
        return subject.endsWith(VALUE_SUFFIX) && subject.length() > VALUE_SUFFIX.length() || subject.endsWith(KEY_SUFFIX) && subject.length() > KEY_SUFFIX.length();
    }

    private static String extractTopicFromSubject(String subject) {
        String topic;
        Objects.requireNonNull(subject, "subject is null");
        if (subject.endsWith(VALUE_SUFFIX)) {
            topic = subject.substring(0, subject.length() - VALUE_SUFFIX.length());
        } else {
            Preconditions.checkState((boolean)subject.endsWith(KEY_SUFFIX), (String)"Unexpected subject name %s", (Object)subject);
            topic = subject.substring(0, subject.length() - KEY_SUFFIX.length());
        }
        Preconditions.checkArgument((!topic.isEmpty() ? 1 : 0) != 0, (String)"Unexpected subject name %s", (Object)subject);
        return topic;
    }

    private static Optional<String> getKeySubjectFromTopic(String topic, Collection<String> subjectsForTopic) {
        String keySubject = topic + KEY_SUFFIX;
        if (subjectsForTopic.contains(keySubject)) {
            return Optional.of(keySubject);
        }
        return Optional.empty();
    }

    private static Optional<String> getValueSubjectFromTopic(String topic, Collection<String> subjectsForTopic) {
        String valueSubject = topic + VALUE_SUFFIX;
        if (subjectsForTopic.contains(valueSubject)) {
            return Optional.of(valueSubject);
        }
        return Optional.empty();
    }

    private static class TopicAndSubjects {
        private final Optional<String> keySubject;
        private final Optional<String> valueSubject;
        private final String topic;

        public TopicAndSubjects(String topic, Optional<String> keySubject, Optional<String> valueSubject) {
            this.topic = Objects.requireNonNull(topic, "topic is null");
            this.keySubject = Objects.requireNonNull(keySubject, "keySubject is null");
            this.valueSubject = Objects.requireNonNull(valueSubject, "valueSubject is null");
        }

        public String getTableName() {
            return this.topic.toLowerCase(Locale.ENGLISH);
        }

        public String getTopic() {
            return this.topic;
        }

        public Optional<String> getKeySubject() {
            return this.keySubject;
        }

        public Optional<String> getValueSubject() {
            return this.valueSubject;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TopicAndSubjects)) {
                return false;
            }
            TopicAndSubjects that = (TopicAndSubjects)other;
            return this.topic.equals(that.topic) && this.keySubject.equals(that.keySubject) && this.valueSubject.equals(that.valueSubject);
        }

        public int hashCode() {
            return Objects.hash(this.topic, this.keySubject, this.valueSubject);
        }
    }

    public static class Factory
    implements Provider<TableDescriptionSupplier> {
        private final SchemaRegistryClient schemaRegistryClient;
        private final Map<String, SchemaParser> schemaParsers;
        private final String defaultSchema;
        private final Duration subjectsCacheRefreshInterval;

        @Inject
        public Factory(SchemaRegistryClient schemaRegistryClient, Map<String, SchemaParser> schemaParsers, KafkaConfig kafkaConfig, ConfluentSchemaRegistryConfig confluentConfig) {
            this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "schemaRegistryClient is null");
            this.schemaParsers = ImmutableMap.copyOf(Objects.requireNonNull(schemaParsers, "schemaParsers is null"));
            Objects.requireNonNull(kafkaConfig, "kafkaConfig is null");
            this.defaultSchema = kafkaConfig.getDefaultSchema();
            Objects.requireNonNull(confluentConfig, "confluentConfig is null");
            this.subjectsCacheRefreshInterval = confluentConfig.getConfluentSubjectsCacheRefreshInterval();
        }

        public TableDescriptionSupplier get() {
            return new ConfluentSchemaRegistryTableDescriptionSupplier(this.schemaRegistryClient, this.schemaParsers, this.defaultSchema, this.subjectsCacheRefreshInterval);
        }
    }
}

