/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.trino.plugin.kafka.KafkaTopicFieldDescription;
import io.trino.plugin.kafka.KafkaTopicFieldGroup;
import io.trino.plugin.kafka.schema.confluent.AvroSchemaConverter;
import io.trino.plugin.kafka.schema.confluent.ConfluentSessionProperties;
import io.trino.plugin.kafka.schema.confluent.SchemaParser;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.avro.Schema;

public class AvroSchemaParser
implements SchemaParser {
    private final TypeManager typeManager;

    @Inject
    public AvroSchemaParser(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    public KafkaTopicFieldGroup parse(ConnectorSession session, String subject, ParsedSchema parsedSchema) {
        Preconditions.checkArgument((boolean)(parsedSchema instanceof AvroSchema), (Object)"parsedSchema should be an instance of AvroSchema");
        Schema schema = ((AvroSchema)parsedSchema).rawSchema();
        AvroSchemaConverter schemaConverter = new AvroSchemaConverter(this.typeManager, ConfluentSessionProperties.getEmptyFieldStrategy(session));
        List<Type> types = schemaConverter.convertAvroSchema(schema);
        ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
        if (schema.getType() != Schema.Type.RECORD) {
            Preconditions.checkState((types.size() == 1 ? 1 : 0) != 0, (Object)"incompatible schema");
            fieldsBuilder.add((Object)new KafkaTopicFieldDescription(subject, (Type)Iterables.getOnlyElement(types), subject, null, null, null, false));
        } else {
            List avroFields = schema.getFields();
            Preconditions.checkState((avroFields.size() == types.size() ? 1 : 0) != 0, (Object)"incompatible schema");
            for (int i = 0; i < types.size(); ++i) {
                Schema.Field field = (Schema.Field)avroFields.get(i);
                fieldsBuilder.add((Object)new KafkaTopicFieldDescription(field.name(), types.get(i), field.name(), null, null, null, false));
            }
        }
        return new KafkaTopicFieldGroup("avro", Optional.empty(), Optional.of(subject), (List<KafkaTopicFieldDescription>)fieldsBuilder.build());
    }
}

