/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json.format;

import io.trino.plugin.kafka.encoder.json.format.JsonDateTimeFormatter;
import io.trino.plugin.kafka.encoder.json.format.util.TimeConversions;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CustomDateTimeFormatter
implements JsonDateTimeFormatter {
    private final DateTimeFormatter formatter;

    public static boolean isSupportedType(Type type) {
        return type.equals(DateType.DATE) || type.equals(TimeType.TIME_MILLIS) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampType.TIMESTAMP_MILLIS) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    }

    public CustomDateTimeFormatter(Optional<String> pattern) {
        this.formatter = DateTimeFormat.forPattern((String)CustomDateTimeFormatter.getPattern(pattern)).withLocale(Locale.ENGLISH).withChronology((Chronology)ISOChronology.getInstanceUTC());
    }

    private static String getPattern(Optional<String> pattern) {
        return pattern.orElseThrow(() -> new IllegalArgumentException("No pattern defined for custom date time format"));
    }

    @Override
    public String formatDate(SqlDate value) {
        return this.formatter.withZoneUTC().print((ReadableInstant)new DateTime(TimeUnit.DAYS.toMillis(value.getDays())));
    }

    @Override
    public String formatTime(SqlTime value, int precision) {
        return this.formatter.withZoneUTC().print((ReadablePartial)LocalTime.fromMillisOfDay((long)TimeConversions.getMillisOfDay(TimeConversions.scalePicosToMillis(value.getPicos()))));
    }

    @Override
    public String formatTimeWithZone(SqlTimeWithTimeZone value) {
        int offsetMinutes = value.getOffsetMinutes();
        DateTimeZone dateTimeZone = DateTimeZone.forOffsetHoursMinutes((int)(offsetMinutes / 60), (int)(offsetMinutes % 60));
        long picos = value.getPicos() - (long)(offsetMinutes * 60) * 1000000000000L;
        return this.formatter.withZone(dateTimeZone).print((ReadableInstant)new DateTime(TimeConversions.scalePicosToMillis(picos), dateTimeZone));
    }

    @Override
    public String formatTimestamp(SqlTimestamp value) {
        return this.formatter.withZoneUTC().print((ReadableInstant)new DateTime(TimeConversions.scaleEpochMicrosToMillis(value.getEpochMicros()), DateTimeZone.UTC));
    }

    @Override
    public String formatTimestampWithZone(SqlTimestampWithTimeZone value) {
        DateTimeZone dateTimeZone = DateTimeZone.forID((String)value.getTimeZoneKey().getId());
        return this.formatter.withZone(dateTimeZone).print((ReadableInstant)new DateTime(value.getEpochMillis(), dateTimeZone));
    }
}

