/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class KafkaTableHandle
implements ConnectorTableHandle,
ConnectorInsertTableHandle {
    private final String schemaName;
    private final String tableName;
    private final String topicName;
    private final String keyDataFormat;
    private final String messageDataFormat;
    private final Optional<String> keyDataSchemaLocation;
    private final Optional<String> messageDataSchemaLocation;
    private final Optional<String> keySubject;
    private final Optional<String> messageSubject;
    private final List<KafkaColumnHandle> columns;
    private final TupleDomain<ColumnHandle> constraint;

    @JsonCreator
    public KafkaTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="topicName") String topicName, @JsonProperty(value="keyDataFormat") String keyDataFormat, @JsonProperty(value="messageDataFormat") String messageDataFormat, @JsonProperty(value="keyDataSchemaLocation") Optional<String> keyDataSchemaLocation, @JsonProperty(value="messageDataSchemaLocation") Optional<String> messageDataSchemaLocation, @JsonProperty(value="keySubject") Optional<String> keySubject, @JsonProperty(value="messageSubject") Optional<String> messageSubject, @JsonProperty(value="columns") List<KafkaColumnHandle> columns, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.topicName = Objects.requireNonNull(topicName, "topicName is null");
        this.keyDataFormat = Objects.requireNonNull(keyDataFormat, "keyDataFormat is null");
        this.messageDataFormat = Objects.requireNonNull(messageDataFormat, "messageDataFormat is null");
        this.keyDataSchemaLocation = Objects.requireNonNull(keyDataSchemaLocation, "keyDataSchemaLocation is null");
        this.messageDataSchemaLocation = Objects.requireNonNull(messageDataSchemaLocation, "messageDataSchemaLocation is null");
        this.keySubject = Objects.requireNonNull(keySubject, "keySubject is null");
        this.messageSubject = Objects.requireNonNull(messageSubject, "messageSubject is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getTopicName() {
        return this.topicName;
    }

    @JsonProperty
    public String getKeyDataFormat() {
        return this.keyDataFormat;
    }

    @JsonProperty
    public String getMessageDataFormat() {
        return this.messageDataFormat;
    }

    @JsonProperty
    public Optional<String> getMessageDataSchemaLocation() {
        return this.messageDataSchemaLocation;
    }

    @JsonProperty
    public Optional<String> getKeyDataSchemaLocation() {
        return this.keyDataSchemaLocation;
    }

    @JsonProperty
    public Optional<String> getKeySubject() {
        return this.keySubject;
    }

    @JsonProperty
    public Optional<String> getMessageSubject() {
        return this.messageSubject;
    }

    @JsonProperty
    public List<KafkaColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.topicName, this.keyDataFormat, this.messageDataFormat, this.keyDataSchemaLocation, this.messageDataSchemaLocation, this.keySubject, this.messageSubject, this.columns, this.constraint);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KafkaTableHandle other = (KafkaTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.topicName, other.topicName) && Objects.equals(this.keyDataFormat, other.keyDataFormat) && Objects.equals(this.messageDataFormat, other.messageDataFormat) && Objects.equals(this.keyDataSchemaLocation, other.keyDataSchemaLocation) && Objects.equals(this.messageDataSchemaLocation, other.messageDataSchemaLocation) && Objects.equals(this.keySubject, other.keySubject) && Objects.equals(this.messageSubject, other.messageSubject) && Objects.equals(this.columns, other.columns) && Objects.equals(this.constraint, other.constraint);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("topicName", (Object)this.topicName).add("keyDataFormat", (Object)this.keyDataFormat).add("messageDataFormat", (Object)this.messageDataFormat).add("keyDataSchemaLocation", this.keyDataSchemaLocation).add("messageDataSchemaLocation", this.messageDataSchemaLocation).add("keySubject", this.keySubject).add("messageSubject", this.messageSubject).add("columns", this.columns).add("constraint", this.constraint).toString();
    }
}

