/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.base.Preconditions;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class KafkaSecurityConfig {
    private SecurityProtocol securityProtocol;

    public Optional<SecurityProtocol> getSecurityProtocol() {
        return Optional.ofNullable(this.securityProtocol);
    }

    @Config(value="kafka.security-protocol")
    @ConfigDescription(value="Kafka communication security protocol")
    public KafkaSecurityConfig setSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
        return this;
    }

    @PostConstruct
    public void validate() {
        Preconditions.checkState((this.securityProtocol == null || this.securityProtocol.equals((Object)SecurityProtocol.PLAINTEXT) || this.securityProtocol.equals((Object)SecurityProtocol.SSL) ? 1 : 0) != 0, (Object)String.format("Only %s and %s security protocols are supported. See 'kafka.config.resources' if other security protocols are needed", SecurityProtocol.PLAINTEXT, SecurityProtocol.SSL));
    }
}

