/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class KafkaInternalFieldManager {
    public static final String PARTITION_ID_FIELD = "_partition_id";
    public static final String PARTITION_OFFSET_FIELD = "_partition_offset";
    public static final String MESSAGE_CORRUPT_FIELD = "_message_corrupt";
    public static final String MESSAGE_FIELD = "_message";
    public static final String MESSAGE_LENGTH_FIELD = "_message_length";
    public static final String HEADERS_FIELD = "_headers";
    public static final String KEY_CORRUPT_FIELD = "_key_corrupt";
    public static final String KEY_FIELD = "_key";
    public static final String KEY_LENGTH_FIELD = "_key_length";
    public static final String OFFSET_TIMESTAMP_FIELD = "_timestamp";
    private final Map<String, InternalField> internalFields;

    @Inject
    public KafkaInternalFieldManager(TypeManager typeManager) {
        Type varcharMapType = typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)TypeSignature.arrayType((TypeSignature)VarbinaryType.VARBINARY.getTypeSignature())));
        this.internalFields = ImmutableMap.builder().put((Object)PARTITION_ID_FIELD, (Object)new InternalField(PARTITION_ID_FIELD, "Partition Id", (Type)BigintType.BIGINT)).put((Object)PARTITION_OFFSET_FIELD, (Object)new InternalField(PARTITION_OFFSET_FIELD, "Offset for the message within the partition", (Type)BigintType.BIGINT)).put((Object)MESSAGE_CORRUPT_FIELD, (Object)new InternalField(MESSAGE_CORRUPT_FIELD, "Message data is corrupt", (Type)BooleanType.BOOLEAN)).put((Object)MESSAGE_FIELD, (Object)new InternalField(MESSAGE_FIELD, "Message text", (Type)VarcharType.createUnboundedVarcharType())).put((Object)HEADERS_FIELD, (Object)new InternalField(HEADERS_FIELD, "Headers of the message as map", varcharMapType)).put((Object)MESSAGE_LENGTH_FIELD, (Object)new InternalField(MESSAGE_LENGTH_FIELD, "Total number of message bytes", (Type)BigintType.BIGINT)).put((Object)KEY_CORRUPT_FIELD, (Object)new InternalField(KEY_CORRUPT_FIELD, "Key data is corrupt", (Type)BooleanType.BOOLEAN)).put((Object)KEY_FIELD, (Object)new InternalField(KEY_FIELD, "Key text", (Type)VarcharType.createUnboundedVarcharType())).put((Object)KEY_LENGTH_FIELD, (Object)new InternalField(KEY_LENGTH_FIELD, "Total number of key bytes", (Type)BigintType.BIGINT)).put((Object)OFFSET_TIMESTAMP_FIELD, (Object)new InternalField(OFFSET_TIMESTAMP_FIELD, "Message timestamp", (Type)TimestampType.TIMESTAMP_MILLIS)).buildOrThrow();
    }

    public Map<String, InternalField> getInternalFields() {
        return this.internalFields;
    }

    public static class InternalField {
        private final String columnName;
        private final String comment;
        private final Type type;

        InternalField(String columnName, String comment, Type type) {
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
            this.comment = Objects.requireNonNull(comment, "comment is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public String getColumnName() {
            return this.columnName;
        }

        private Type getType() {
            return this.type;
        }

        KafkaColumnHandle getColumnHandle(int index, boolean hidden) {
            return new KafkaColumnHandle(this.getColumnName(), this.getType(), null, null, null, false, hidden, true);
        }

        ColumnMetadata getColumnMetadata(boolean hidden) {
            return ColumnMetadata.builder().setName(this.columnName).setType(this.type).setComment(Optional.ofNullable(this.comment)).setHidden(hidden).build();
        }
    }
}

