/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.kafka.encoder.AbstractRowEncoder;
import io.trino.plugin.kafka.encoder.EncoderColumnHandle;
import io.trino.plugin.kafka.encoder.json.format.DateTimeFormat;
import io.trino.plugin.kafka.encoder.json.format.JsonDateTimeFormatter;
import io.trino.plugin.kafka.encoder.json.format.UnimplementedJsonDateTimeFormatter;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class JsonRowEncoder
extends AbstractRowEncoder {
    private static final Set<Type> SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)SmallintType.SMALLINT, (Object)TinyintType.TINYINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object[])new Type[0]);
    public static final String NAME = "json";
    private final ObjectMapper objectMapper;
    private final ObjectNode node;
    private final List<JsonDateTimeFormatter> dateTimeFormatters;

    JsonRowEncoder(ConnectorSession session, List<EncoderColumnHandle> columnHandles, ObjectMapper objectMapper) {
        super(session, columnHandles);
        ImmutableList.Builder dateTimeFormatters = ImmutableList.builder();
        for (EncoderColumnHandle columnHandle : this.columnHandles) {
            Preconditions.checkArgument((boolean)JsonRowEncoder.isSupportedType(columnHandle.getType()), (String)"Unsupported column type '%s' for column '%s'", (Object)columnHandle.getType(), (Object)columnHandle.getName());
            if (JsonRowEncoder.isSupportedTemporalType(columnHandle.getType())) {
                Preconditions.checkArgument((columnHandle.getDataFormat() != null ? 1 : 0) != 0, (String)"Unsupported or no dataFormat '%s' defined for temporal column '%s'", (Object)columnHandle.getDataFormat(), (Object)columnHandle.getName());
                DateTimeFormat dataFormat = JsonRowEncoder.parseDataFormat(columnHandle.getDataFormat(), columnHandle.getName());
                Preconditions.checkArgument((boolean)dataFormat.isSupportedType(columnHandle.getType()), (String)"Unsupported column type '%s' for column '%s'", (Object)columnHandle.getType(), (Object)columnHandle.getName());
                if (dataFormat == DateTimeFormat.CUSTOM_DATE_TIME) {
                    Preconditions.checkArgument((columnHandle.getFormatHint() != null ? 1 : 0) != 0, (String)"No format hint defined for column '%s'", (Object)columnHandle.getName());
                } else {
                    Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"Unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)columnHandle.getName());
                }
                dateTimeFormatters.add((Object)dataFormat.getFormatter(Optional.ofNullable(columnHandle.getFormatHint())));
                continue;
            }
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"Unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)columnHandle.getName());
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"Unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)columnHandle.getName());
            dateTimeFormatters.add((Object)new UnimplementedJsonDateTimeFormatter());
        }
        this.dateTimeFormatters = dateTimeFormatters.build();
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.node = objectMapper.createObjectNode();
    }

    private static boolean isSupportedType(Type type) {
        return type instanceof VarcharType || SUPPORTED_PRIMITIVE_TYPES.contains(type) || JsonRowEncoder.isSupportedTemporalType(type);
    }

    private static boolean isSupportedTemporalType(Type type) {
        return type.equals(DateType.DATE) || type.equals(TimeType.TIME_MILLIS) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampType.TIMESTAMP_MILLIS) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    }

    private static DateTimeFormat parseDataFormat(String dataFormat, String columnName) {
        try {
            return DateTimeFormat.valueOf(dataFormat.toUpperCase(Locale.ENGLISH).replaceAll("-", "_").strip());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unable to parse data format '%s' for column '%s'", dataFormat, columnName), e);
        }
    }

    private String currentColumnMapping() {
        return ((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getMapping();
    }

    @Override
    protected void appendNullValue() {
        this.node.putNull(this.currentColumnMapping());
    }

    @Override
    protected void appendLong(long value) {
        this.node.put(this.currentColumnMapping(), value);
    }

    @Override
    protected void appendInt(int value) {
        this.node.put(this.currentColumnMapping(), value);
    }

    @Override
    protected void appendShort(short value) {
        this.node.put(this.currentColumnMapping(), value);
    }

    @Override
    protected void appendByte(byte value) {
        this.node.put(this.currentColumnMapping(), (short)value);
    }

    @Override
    protected void appendDouble(double value) {
        this.node.put(this.currentColumnMapping(), value);
    }

    @Override
    protected void appendFloat(float value) {
        this.node.put(this.currentColumnMapping(), value);
    }

    @Override
    protected void appendBoolean(boolean value) {
        this.node.put(this.currentColumnMapping(), value);
    }

    @Override
    protected void appendString(String value) {
        this.node.put(this.currentColumnMapping(), value);
    }

    @Override
    protected void appendByteBuffer(ByteBuffer value) {
        this.node.put(this.currentColumnMapping(), value.array());
    }

    @Override
    protected void appendSqlDate(SqlDate value) {
        this.node.put(this.currentColumnMapping(), this.dateTimeFormatters.get(this.currentColumnIndex).formatDate(value));
    }

    @Override
    protected void appendSqlTime(SqlTime value) {
        int precision = ((TimeType)((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getType()).getPrecision();
        this.node.put(this.currentColumnMapping(), this.dateTimeFormatters.get(this.currentColumnIndex).formatTime(value, precision));
    }

    @Override
    protected void appendSqlTimeWithTimeZone(SqlTimeWithTimeZone value) {
        this.node.put(this.currentColumnMapping(), this.dateTimeFormatters.get(this.currentColumnIndex).formatTimeWithZone(value));
    }

    @Override
    protected void appendSqlTimestamp(SqlTimestamp value) {
        this.node.put(this.currentColumnMapping(), this.dateTimeFormatters.get(this.currentColumnIndex).formatTimestamp(value));
    }

    @Override
    protected void appendSqlTimestampWithTimeZone(SqlTimestampWithTimeZone value) {
        this.node.put(this.currentColumnMapping(), this.dateTimeFormatters.get(this.currentColumnIndex).formatTimestampWithZone(value));
    }

    @Override
    public byte[] toByteArray() {
        Preconditions.checkArgument((this.currentColumnIndex == this.columnHandles.size() ? 1 : 0) != 0, (Object)String.format("Missing %d columns", this.columnHandles.size() - this.currentColumnIndex + 1));
        try {
            this.resetColumnIndex();
            return this.objectMapper.writeValueAsBytes((Object)this.node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

