/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.kafka.KafkaAdminFactory;
import io.trino.plugin.kafka.security.ForKafkaSsl;
import io.trino.plugin.kafka.security.KafkaSslConfig;
import io.trino.spi.connector.ConnectorSession;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;

public class SslKafkaAdminFactory
implements KafkaAdminFactory {
    private final ImmutableMap<String, Object> map;
    private final KafkaAdminFactory delegate;

    @Inject
    public SslKafkaAdminFactory(@ForKafkaSsl KafkaAdminFactory delegate, KafkaSslConfig sslConfig) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(sslConfig, "sslConfig is null");
        this.map = ImmutableMap.copyOf(sslConfig.getKafkaClientProperties());
    }

    @Override
    public Properties configure(ConnectorSession session) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.delegate.configure(session));
        properties.putAll((Map<?, ?>)this.map);
        return properties;
    }
}

