/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.utils;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.kafka.utils.PropertiesUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPropertiesUtils {
    @Test
    public void testReadPropertiesOverwritten() throws IOException {
        ImmutableMap expected = ImmutableMap.builder().put((Object)"security.protocol", (Object)"OVERWRITTEN").put((Object)"group.id", (Object)"consumer").put((Object)"client.id", (Object)"producer").buildOrThrow();
        Properties firstProperties = new Properties();
        firstProperties.putAll((Map<?, ?>)ImmutableMap.builder().put((Object)"security.protocol", (Object)"SASL_PLAINTEXT").put((Object)"group.id", (Object)"consumer").buildOrThrow());
        File firstFile = this.writePropertiesToFile(firstProperties);
        Properties secondProperties = new Properties();
        secondProperties.putAll((Map<?, ?>)ImmutableMap.builder().put((Object)"security.protocol", (Object)"OVERWRITTEN").put((Object)"client.id", (Object)"producer").buildOrThrow());
        File secondFile = this.writePropertiesToFile(secondProperties);
        Map result = PropertiesUtils.readProperties(Arrays.asList(firstFile, secondFile));
        Assert.assertEquals((Map)result, (Map)expected);
    }

    private File writePropertiesToFile(Properties properties) throws IOException {
        Path path = Files.createTempFile(null, null, new FileAttribute[0]);
        try (FileOutputStream outputStream = new FileOutputStream(path.toString());){
            properties.store(outputStream, null);
        }
        return path.toFile();
    }
}

