/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.util;

import com.google.common.io.ByteStreams;
import io.airlift.json.JsonCodec;
import io.trino.plugin.kafka.KafkaTopicDescription;
import io.trino.spi.connector.SchemaTableName;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;

public final class TestUtils {
    private TestUtils() {
    }

    public static Map.Entry<SchemaTableName, KafkaTopicDescription> loadTpchTopicDescription(JsonCodec<KafkaTopicDescription> topicDescriptionJsonCodec, String topicName, SchemaTableName schemaTableName) throws IOException {
        KafkaTopicDescription tpchTemplate = (KafkaTopicDescription)topicDescriptionJsonCodec.fromJson(ByteStreams.toByteArray((InputStream)TestUtils.class.getResourceAsStream(String.format("/tpch/%s.json", schemaTableName.getTableName()))));
        return new AbstractMap.SimpleImmutableEntry<SchemaTableName, KafkaTopicDescription>(schemaTableName, new KafkaTopicDescription(schemaTableName.getTableName(), Optional.of(schemaTableName.getSchemaName()), topicName, tpchTemplate.getKey(), tpchTemplate.getMessage()));
    }

    public static Map.Entry<SchemaTableName, KafkaTopicDescription> createEmptyTopicDescription(String topicName, SchemaTableName schemaTableName) {
        return new AbstractMap.SimpleImmutableEntry<SchemaTableName, KafkaTopicDescription>(schemaTableName, new KafkaTopicDescription(schemaTableName.getTableName(), Optional.of(schemaTableName.getSchemaName()), topicName, Optional.empty(), Optional.empty()));
    }
}

