/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.util;

import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.base.TypeDeserializer;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Provider;

public final class CodecSupplier<T>
implements Supplier<JsonCodec<T>> {
    private final JsonCodecFactory codecFactory;
    private final Class<T> clazz;

    public CodecSupplier(Class<T> clazz, TypeManager typeManager) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(arg_0 -> ((TypeManager)typeManager).getType(arg_0))));
        this.codecFactory = new JsonCodecFactory((Provider)objectMapperProvider);
        this.clazz = Objects.requireNonNull(clazz, "clazz is null");
    }

    @Override
    public JsonCodec<T> get() {
        return this.codecFactory.jsonCodec(this.clazz);
    }
}

