/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.kafka.schema.confluent.AvroSchemaConverter;
import io.trino.plugin.kafka.schema.confluent.ConfluentSchemaRegistryConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestConfluentSchemaRegistryConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ConfluentSchemaRegistryConfig)ConfigAssertions.recordDefaults(ConfluentSchemaRegistryConfig.class)).setConfluentSchemaRegistryUrls(null).setConfluentSchemaRegistryClientCacheSize(1000).setEmptyFieldStrategy(AvroSchemaConverter.EmptyFieldStrategy.IGNORE).setConfluentSubjectsCacheRefreshInterval(new Duration(1.0, TimeUnit.SECONDS)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"kafka.confluent-schema-registry-url", (Object)"http://schema-registry-a:8081, http://schema-registry-b:8081").put((Object)"kafka.confluent-schema-registry-client-cache-size", (Object)"1500").put((Object)"kafka.empty-field-strategy", (Object)"ADD_DUMMY").put((Object)"kafka.confluent-subjects-cache-refresh-interval", (Object)"2s").buildOrThrow();
        ConfluentSchemaRegistryConfig expected = new ConfluentSchemaRegistryConfig().setConfluentSchemaRegistryUrls("http://schema-registry-a:8081, http://schema-registry-b:8081").setConfluentSchemaRegistryClientCacheSize(1500).setEmptyFieldStrategy(AvroSchemaConverter.EmptyFieldStrategy.ADD_DUMMY).setConfluentSubjectsCacheRefreshInterval(new Duration(2.0, TimeUnit.SECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

