/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.plugin.kafka.schema.confluent.AvroSchemaConverter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAvroSchemaConverter {
    private static final String RECORD_NAME = "test";
    private static final TypeManager TYPE_MANAGER = new TestingTypeManager();

    @Test
    public void testConvertSchema() {
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FixedDefault)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)RECORD_NAME).fields().name("bool_col").type().booleanType().noDefault().name("int_col").type().intType().noDefault().name("long_col").type().longType().noDefault().name("float_col").type().floatType().noDefault().name("double_col").type().doubleType().noDefault().name("string_col").type().stringType().noDefault().name("enum_col").type().enumeration("colors").symbols(new String[]{"blue", "red", "yellow"})).noDefault().name("bytes_col").type().bytesType().noDefault().name("fixed_col").type().fixed("fixed").size(5)).noDefault().name("union_col").type().unionOf().nullType().and().floatType()).and().doubleType()).endUnion()).noDefault().name("union_col2").type().unionOf().nullType().and().intType()).and().longType()).endUnion()).noDefault().name("union_col3").type().unionOf().nullType().and().bytesType()).and().type("fixed")).endUnion()).noDefault().name("union_col4").type().unionOf().nullType().and().type("colors")).and().stringType()).endUnion()).noDefault().name("list_col").type().array().items().intType()).noDefault().name("map_col").type().map().values().intType()).noDefault().name("record_col").type().record("record_col").fields().name("nested_list").type().array().items().map().values().stringType()).noDefault().name("nested_map").type().map().values().array().items().stringType()).noDefault().endRecord()).noDefault().endRecord();
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.IGNORE);
        List types = avroSchemaConverter.convertAvroSchema(schema);
        ImmutableList expected = ImmutableList.builder().add((Object)BooleanType.BOOLEAN).add((Object)IntegerType.INTEGER).add((Object)BigintType.BIGINT).add((Object)RealType.REAL).add((Object)DoubleType.DOUBLE).add((Object)VarcharType.VARCHAR).add((Object)VarcharType.VARCHAR).add((Object)VarbinaryType.VARBINARY).add((Object)VarbinaryType.VARBINARY).add((Object)DoubleType.DOUBLE).add((Object)BigintType.BIGINT).add((Object)VarbinaryType.VARBINARY).add((Object)VarcharType.VARCHAR).add((Object)new ArrayType((Type)IntegerType.INTEGER)).add((Object)TestAvroSchemaConverter.createType((Type)IntegerType.INTEGER)).add((Object)RowType.from((List)ImmutableList.builder().add((Object)new RowType.Field(Optional.of("nested_list"), (Type)new ArrayType(TestAvroSchemaConverter.createType((Type)VarcharType.VARCHAR)))).add((Object)new RowType.Field(Optional.of("nested_map"), TestAvroSchemaConverter.createType((Type)new ArrayType((Type)VarcharType.VARCHAR)))).build())).build();
        Assert.assertEquals((Collection)types, (Collection)expected);
    }

    @Test
    public void testTypesWithDefaults() {
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FixedDefault)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)RECORD_NAME).fields().name("bool_col").type().booleanType().booleanDefault(true).name("int_col").type().intType().intDefault(3).name("long_col").type().longType().longDefault(3L).name("float_col").type().floatType().floatDefault(3.3f).name("double_col").type().doubleType().doubleDefault(3.3).name("string_col").type().stringType().stringDefault("three").name("enum_col").type().enumeration("colors").symbols(new String[]{"blue", "red", "yellow"})).enumDefault("yellow").name("bytes_col").type().bytesType().bytesDefault(new byte[]{1, 2, 3}).name("fixed_col").type().fixed("fixed").size(5)).fixedDefault(new byte[]{1, 2, 3}).name("union_col").type().unionOf().nullType().and().floatType()).and().doubleType()).endUnion()).nullDefault().name("union_col2").type().unionOf().nullType().and().intType()).and().longType()).endUnion()).nullDefault().name("union_col3").type().unionOf().nullType().and().bytesType()).and().type("fixed")).endUnion()).nullDefault().name("union_col4").type().unionOf().nullType().and().type("colors")).and().stringType()).endUnion()).nullDefault().name("list_col").type().array().items().intType()).arrayDefault(Arrays.asList(1, 2, 3)).name("map_col").type().map().values().intType()).mapDefault((Map)ImmutableMap.builder().put((Object)"one", (Object)1).put((Object)"two", (Object)2).buildOrThrow()).name("record_col").type().record("record_col").fields().name("nested_list").type().array().items().map().values().stringType()).noDefault().name("nested_map").type().map().values().array().items().stringType()).noDefault().endRecord()).recordDefault((GenericRecord)new GenericRecordBuilder((Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"record_col").fields().name("nested_list").type().array().items().map().values().stringType()).noDefault().name("nested_map").type().map().values().array().items().stringType()).noDefault().endRecord()).set("nested_list", Arrays.asList(ImmutableMap.builder().put((Object)"key", (Object)"value").put((Object)"key1", (Object)"value1").buildOrThrow(), ImmutableMap.builder().put((Object)"key2", (Object)"value2").put((Object)"key3", (Object)"value3").buildOrThrow())).set("nested_map", (Object)ImmutableMap.builder().put((Object)"key1", Arrays.asList("one", "two", "three")).put((Object)"key2", Arrays.asList("four", "two", "three")).buildOrThrow()).build()).endRecord();
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.IGNORE);
        List types = avroSchemaConverter.convertAvroSchema(schema);
        ImmutableList expected = ImmutableList.builder().add((Object)BooleanType.BOOLEAN).add((Object)IntegerType.INTEGER).add((Object)BigintType.BIGINT).add((Object)RealType.REAL).add((Object)DoubleType.DOUBLE).add((Object)VarcharType.VARCHAR).add((Object)VarcharType.VARCHAR).add((Object)VarbinaryType.VARBINARY).add((Object)VarbinaryType.VARBINARY).add((Object)DoubleType.DOUBLE).add((Object)BigintType.BIGINT).add((Object)VarbinaryType.VARBINARY).add((Object)VarcharType.VARCHAR).add((Object)new ArrayType((Type)IntegerType.INTEGER)).add((Object)TestAvroSchemaConverter.createType((Type)IntegerType.INTEGER)).add((Object)RowType.from((List)ImmutableList.builder().add((Object)new RowType.Field(Optional.of("nested_list"), (Type)new ArrayType(TestAvroSchemaConverter.createType((Type)VarcharType.VARCHAR)))).add((Object)new RowType.Field(Optional.of("nested_map"), TestAvroSchemaConverter.createType((Type)new ArrayType((Type)VarcharType.VARCHAR)))).build())).build();
        Assert.assertEquals((Collection)types, (Collection)expected);
    }

    @Test
    public void testNullableColumns() {
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FixedDefault)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)RECORD_NAME).fields().name("bool_col").type().nullable().booleanType().noDefault().name("int_col").type().nullable().intType().noDefault().name("long_col").type().nullable().longType().noDefault().name("float_col").type().nullable().floatType().noDefault().name("double_col").type().nullable().doubleType().noDefault().name("string_col").type().nullable().stringType().noDefault().name("enum_col").type().nullable().enumeration("colors").symbols(new String[]{"blue", "red", "yellow"})).noDefault().name("bytes_col").type().nullable().bytesType().noDefault().name("fixed_col").type().nullable().fixed("fixed").size(5)).noDefault().name("union_col").type().unionOf().nullType().and().floatType()).and().doubleType()).endUnion()).noDefault().name("union_col2").type().unionOf().nullType().and().intType()).and().longType()).endUnion()).noDefault().name("union_col3").type().unionOf().nullType().and().bytesType()).and().type("fixed")).endUnion()).noDefault().name("union_col4").type().unionOf().nullType().and().type("colors")).and().stringType()).endUnion()).noDefault().name("list_col").type().nullable().array().items().intType()).noDefault().name("map_col").type().nullable().map().values().intType()).noDefault().name("record_col").type().nullable().record("record_col").fields().name("nested_list").type().nullable().array().items().map().values().stringType()).noDefault().name("nested_map").type().nullable().map().values().array().items().stringType()).noDefault().endRecord()).noDefault().endRecord();
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.IGNORE);
        List types = avroSchemaConverter.convertAvroSchema(schema);
        ImmutableList expected = ImmutableList.builder().add((Object)BooleanType.BOOLEAN).add((Object)IntegerType.INTEGER).add((Object)BigintType.BIGINT).add((Object)RealType.REAL).add((Object)DoubleType.DOUBLE).add((Object)VarcharType.VARCHAR).add((Object)VarcharType.VARCHAR).add((Object)VarbinaryType.VARBINARY).add((Object)VarbinaryType.VARBINARY).add((Object)DoubleType.DOUBLE).add((Object)BigintType.BIGINT).add((Object)VarbinaryType.VARBINARY).add((Object)VarcharType.VARCHAR).add((Object)new ArrayType((Type)IntegerType.INTEGER)).add((Object)TestAvroSchemaConverter.createType((Type)IntegerType.INTEGER)).add((Object)RowType.from((List)ImmutableList.builder().add((Object)new RowType.Field(Optional.of("nested_list"), (Type)new ArrayType(TestAvroSchemaConverter.createType((Type)VarcharType.VARCHAR)))).add((Object)new RowType.Field(Optional.of("nested_map"), TestAvroSchemaConverter.createType((Type)new ArrayType((Type)VarcharType.VARCHAR)))).build())).build();
        Assert.assertEquals((Collection)types, (Collection)expected);
    }

    @Test
    public void testUnsupportedUnionType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.IGNORE).convertAvroSchema((Schema)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)RECORD_NAME).fields().name("union_col").type().unionOf().nullType().and().floatType()).and().longType()).endUnion()).noDefault().endRecord())).isInstanceOf(UnsupportedOperationException.class)).hasMessageStartingWith("Incompatible UNION type:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.IGNORE).convertAvroSchema((Schema)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)RECORD_NAME).fields().name("union_col").type().unionOf().nullType().and().fixed("fixed").size(5)).and().stringType()).endUnion()).noDefault().endRecord())).isInstanceOf(UnsupportedOperationException.class)).hasMessageStartingWith("Incompatible UNION type:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.IGNORE).convertAvroSchema((Schema)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)RECORD_NAME).fields().name("union_col").type().unionOf().nullType().and().booleanType()).and().intType()).endUnion()).noDefault().endRecord())).isInstanceOf(UnsupportedOperationException.class)).hasMessageStartingWith("Incompatible UNION type:");
    }

    @Test
    public void testSimpleSchema() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.LONG);
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.IGNORE);
        List types = avroSchemaConverter.convertAvroSchema(schema);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)types), (Object)BigintType.BIGINT);
    }

    @Test
    public void testEmptyFieldStrategy() {
        Schema schema = (Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)RECORD_NAME).fields().name("my_int").type().intType().noDefault().name("my_record").type().record("nested_record").fields().endRecord()).noDefault().name("my_array").type().array().items().type("nested_record")).noDefault().name("my_map").type().map().values().type("nested_record")).noDefault().endRecord();
        ImmutableList typesForIgnoreStrategy = ImmutableList.builder().add((Object)IntegerType.INTEGER).build();
        Assert.assertEquals((Collection)new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.IGNORE).convertAvroSchema(schema), (Collection)typesForIgnoreStrategy);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.FAIL).convertAvroSchema(schema)).isInstanceOf(IllegalStateException.class)).hasMessage("Struct type has no valid fields for schema: '%s'", new Object[]{SchemaBuilder.record((String)"nested_record").fields().endRecord()});
        ImmutableList typesForAddDummyStrategy = ImmutableList.builder().add((Object)IntegerType.INTEGER).add((Object)RowType.from((List)ImmutableList.builder().add((Object)new RowType.Field(Optional.of("dummy"), (Type)BooleanType.BOOLEAN)).build())).add((Object)new ArrayType((Type)RowType.from((List)ImmutableList.builder().add((Object)new RowType.Field(Optional.of("dummy"), (Type)BooleanType.BOOLEAN)).build()))).add((Object)TestAvroSchemaConverter.createType((Type)RowType.from((List)ImmutableList.builder().add((Object)new RowType.Field(Optional.of("dummy"), (Type)BooleanType.BOOLEAN)).build()))).build();
        Assert.assertEquals((Collection)new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.ADD_DUMMY).convertAvroSchema(schema), (Collection)typesForAddDummyStrategy);
    }

    @Test
    public void testEmptyFieldStrategyForEmptySchema() {
        Schema schema = (Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)RECORD_NAME).fields().name("my_record").type().record("nested_record").fields().endRecord()).noDefault().name("my_array").type().array().items().type("nested_record")).noDefault().name("my_map").type().map().values().type("nested_record")).noDefault().endRecord();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.IGNORE).convertAvroSchema(schema)).isInstanceOf(IllegalStateException.class)).hasMessage("Schema has no valid fields: '%s'", new Object[]{schema});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.FAIL).convertAvroSchema(schema)).isInstanceOf(IllegalStateException.class)).hasMessage("Struct type has no valid fields for schema: '%s'", new Object[]{SchemaBuilder.record((String)"nested_record").fields().endRecord()});
        ImmutableList typesForAddDummyStrategy = ImmutableList.builder().add((Object)RowType.from((List)ImmutableList.builder().add((Object)new RowType.Field(Optional.of("dummy"), (Type)BooleanType.BOOLEAN)).build())).add((Object)new ArrayType((Type)RowType.from((List)ImmutableList.builder().add((Object)new RowType.Field(Optional.of("dummy"), (Type)BooleanType.BOOLEAN)).build()))).add((Object)TestAvroSchemaConverter.createType((Type)RowType.from((List)ImmutableList.builder().add((Object)new RowType.Field(Optional.of("dummy"), (Type)BooleanType.BOOLEAN)).build()))).build();
        Assert.assertEquals((Collection)new AvroSchemaConverter((TypeManager)new TestingTypeManager(), AvroSchemaConverter.EmptyFieldStrategy.ADD_DUMMY).convertAvroSchema(schema), (Collection)typesForAddDummyStrategy);
    }

    private static Type createType(Type valueType) {
        VarcharType keyType = VarcharType.VARCHAR;
        return new MapType((Type)keyType, valueType, TYPE_MANAGER.getTypeOperators());
    }
}

