/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.trino.plugin.kafka.KafkaTableHandle;
import io.trino.plugin.kafka.schema.confluent.AvroConfluentContentSchemaReader;
import io.trino.spi.TrinoException;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAvroConfluentContentSchemaReader {
    private static final String TOPIC = "test";
    private static final String SUBJECT_NAME = String.format("%s-value", "test");

    @Test
    public void testAvroConfluentSchemaReader() throws Exception {
        MockSchemaRegistryClient mockSchemaRegistryClient = new MockSchemaRegistryClient();
        Schema schema = TestAvroConfluentContentSchemaReader.getAvroSchema();
        mockSchemaRegistryClient.register(SUBJECT_NAME, schema);
        AvroConfluentContentSchemaReader avroConfluentSchemaReader = new AvroConfluentContentSchemaReader((SchemaRegistryClient)mockSchemaRegistryClient);
        KafkaTableHandle tableHandle = new KafkaTableHandle("default", TOPIC, TOPIC, "avro", "avro", Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(SUBJECT_NAME), (List)ImmutableList.of(), TupleDomain.all());
        Assert.assertEquals((Object)avroConfluentSchemaReader.readValueContentSchema(tableHandle), Optional.of(schema).map(Schema::toString));
        Assert.assertEquals((Object)avroConfluentSchemaReader.readKeyContentSchema(tableHandle), Optional.empty());
        KafkaTableHandle invalidTableHandle = new KafkaTableHandle("default", TOPIC, TOPIC, "avro", "avro", Optional.empty(), Optional.empty(), Optional.empty(), Optional.of("another-schema"), (List)ImmutableList.of(), TupleDomain.all());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> avroConfluentSchemaReader.readValueContentSchema(invalidTableHandle)).isInstanceOf(TrinoException.class)).hasMessage("Could not resolve schema for the 'another-schema' subject");
    }

    @Test
    public void testAvroSchemaWithReferences() throws Exception {
        MockSchemaRegistryClient mockSchemaRegistryClient = new MockSchemaRegistryClient();
        int schemaId = mockSchemaRegistryClient.register("base_schema-value", (ParsedSchema)new AvroSchema(TestAvroConfluentContentSchemaReader.getAvroSchema()));
        ParsedSchema schemaWithReference = (ParsedSchema)mockSchemaRegistryClient.parseSchema(null, TestAvroConfluentContentSchemaReader.getAvroSchemaWithReference(), (List)ImmutableList.of((Object)new SchemaReference(TOPIC, "base_schema-value", Integer.valueOf(schemaId)))).orElseThrow();
        mockSchemaRegistryClient.register(SUBJECT_NAME, schemaWithReference);
        AvroConfluentContentSchemaReader avroConfluentSchemaReader = new AvroConfluentContentSchemaReader((SchemaRegistryClient)mockSchemaRegistryClient);
        Assertions.assertThat(avroConfluentSchemaReader.readSchema(Optional.empty(), Optional.of(SUBJECT_NAME)).map(schema -> new Schema.Parser().parse(schema))).isPresent();
    }

    private static String getAvroSchemaWithReference() {
        return "{\n    \"type\":\"record\",\n    \"name\":\"Schema2\",\n    \"fields\":[\n        {\"name\":\"referred\",\"type\": \"test\"},\n        {\"name\":\"col3\",\"type\": \"string\"}\n    ]\n}";
    }

    private static Schema getAvroSchema() {
        return (Schema)SchemaBuilder.record((String)TOPIC).fields().name("col1").type().intType().noDefault().name("col2").type().stringType().noDefault().endRecord();
    }
}

