/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.trino.plugin.kafka.KafkaQueryRunnerBuilder;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.kafka.TestingKafka;
import java.util.HashMap;

public final class KafkaWithConfluentSchemaRegistryQueryRunner {
    private static final String DEFAULT_SCHEMA = "default";

    private KafkaWithConfluentSchemaRegistryQueryRunner() {
    }

    public static Builder builder(TestingKafka testingKafka) {
        return new Builder(testingKafka);
    }

    public static void main(String[] args) throws Exception {
        Logging.initialize();
        DistributedQueryRunner queryRunner = KafkaWithConfluentSchemaRegistryQueryRunner.builder(TestingKafka.createWithSchemaRegistry()).build();
        Logger log = Logger.get(KafkaWithConfluentSchemaRegistryQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }

    public static class Builder
    extends KafkaQueryRunnerBuilder {
        protected Builder(TestingKafka testingKafka) {
            super(testingKafka, KafkaWithConfluentSchemaRegistryQueryRunner.DEFAULT_SCHEMA);
        }

        @Override
        public void preInit(DistributedQueryRunner queryRunner) {
            HashMap<String, String> properties = new HashMap<String, String>(this.extraKafkaProperties);
            properties.putIfAbsent("kafka.table-description-supplier", "confluent");
            properties.putIfAbsent("kafka.confluent-schema-registry-url", this.testingKafka.getSchemaRegistryConnectString());
            this.setExtraKafkaProperties(properties);
        }
    }
}

