/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.raw;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.plugin.kafka.encoder.RowEncoder;
import io.trino.plugin.kafka.encoder.raw.RawRowEncoderFactory;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRawEncoderMapping {
    private static final RawRowEncoderFactory ENCODER_FACTORY = new RawRowEncoderFactory();

    @Test
    public void testMapping() {
        KafkaColumnHandle col1 = new KafkaColumnHandle("test1", (Type)BigintType.BIGINT, "0", "LONG", null, false, false, false);
        KafkaColumnHandle col2 = new KafkaColumnHandle("test2", (Type)VarcharType.createUnboundedVarcharType(), "8:14", "BYTE", null, false, false, false);
        KafkaColumnHandle col3 = new KafkaColumnHandle("test3", (Type)BigintType.BIGINT, "14", "LONG", null, false, false, false);
        KafkaColumnHandle col4 = new KafkaColumnHandle("test4", (Type)VarcharType.createUnboundedVarcharType(), "22:28", "BYTE", null, false, false, false);
        KafkaColumnHandle col5 = new KafkaColumnHandle("test5", (Type)BigintType.BIGINT, "28", "LONG", null, false, false, false);
        KafkaColumnHandle col6 = new KafkaColumnHandle("test6", (Type)VarcharType.createVarcharType((int)6), "36:42", "BYTE", null, false, false, false);
        KafkaColumnHandle col7 = new KafkaColumnHandle("test7", (Type)VarcharType.createVarcharType((int)6), "42:48", "BYTE", null, false, false, false);
        RowEncoder rowEncoder = ENCODER_FACTORY.create(TestingConnectorSession.SESSION, Optional.empty(), (List)ImmutableList.of((Object)col1, (Object)col2, (Object)col3, (Object)col4, (Object)col5, (Object)col6, (Object)col7));
        ByteBuffer buf = ByteBuffer.allocate(48);
        buf.putLong(123456789L);
        buf.put("abcdef".getBytes(StandardCharsets.UTF_8));
        buf.putLong(123456789L);
        buf.put("abcdef".getBytes(StandardCharsets.UTF_8));
        buf.putLong(123456789L);
        buf.put("abcdef".getBytes(StandardCharsets.UTF_8));
        buf.put("abcdef".getBytes(StandardCharsets.UTF_8));
        Block longArrayBlock = new LongArrayBlockBuilder(null, 1).writeLong(123456789L).closeEntry().build();
        Block varArrayBlock = new VariableWidthBlockBuilder(null, 1, 6).writeBytes(Slices.wrappedBuffer((byte[])"abcdef".getBytes(StandardCharsets.UTF_8)), 0, 6).closeEntry().build();
        rowEncoder.appendColumnValue(longArrayBlock, 0);
        rowEncoder.appendColumnValue(varArrayBlock, 0);
        rowEncoder.appendColumnValue(longArrayBlock, 0);
        rowEncoder.appendColumnValue(varArrayBlock, 0);
        rowEncoder.appendColumnValue(longArrayBlock, 0);
        rowEncoder.appendColumnValue(varArrayBlock, 0);
        rowEncoder.appendColumnValue(varArrayBlock, 0);
        Assert.assertEquals((Object)buf.array(), (Object)rowEncoder.toByteArray());
    }
}

