/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json;

import io.trino.plugin.kafka.encoder.json.format.DateTimeFormat;
import io.trino.plugin.kafka.encoder.json.format.JsonDateTimeFormatter;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.assertions.Assert;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestRFC2822JsonDateTimeFormatter {
    private static JsonDateTimeFormatter getFormatter() {
        return DateTimeFormat.RFC2822.getFormatter(Optional.empty());
    }

    private static void testTimestamp(SqlTimestamp value, String expectedLiteral) {
        String actualLiteral = TestRFC2822JsonDateTimeFormatter.getFormatter().formatTimestamp(value);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    private static void testTimestampWithTZ(SqlTimestampWithTimeZone value, String expectedLiteral) {
        String actualLiteral = TestRFC2822JsonDateTimeFormatter.getFormatter().formatTimestampWithZone(value);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    @Test
    public void testRFC2822DateTimeFunctions() {
        TestRFC2822JsonDateTimeFormatter.testTimestamp(DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2020, (int)8, (int)18, (int)12, (int)38, (int)29, (int)0), "Tue Aug 18 12:38:29 +0000 2020");
        TestRFC2822JsonDateTimeFormatter.testTimestamp(DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0), "Thu Jan 01 00:00:00 +0000 1970");
        TestRFC2822JsonDateTimeFormatter.testTimestamp(DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1800, (int)8, (int)18, (int)12, (int)38, (int)29, (int)0), "Mon Aug 18 12:38:29 +0000 1800");
        TestRFC2822JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), "Wed Aug 19 12:23:41 +0000 2020");
        TestRFC2822JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"America/New_York")), "Wed Aug 19 12:23:41 -0400 2020");
        TestRFC2822JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)1800, (int)8, (int)19, (int)12, (int)23, (int)41, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"America/New_York")), "Tue Aug 19 12:23:41 -0456 1800");
        TestRFC2822JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Asia/Hong_Kong")), "Wed Aug 19 12:23:41 +0800 2020");
        TestRFC2822JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)0, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Africa/Mogadishu")), "Wed Aug 19 12:23:41 +0300 2020");
        TestRFC2822JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), "Thu Jan 01 00:00:00 +0000 1970");
    }
}

