/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json;

import io.trino.plugin.kafka.encoder.json.format.DateTimeFormat;
import io.trino.plugin.kafka.encoder.json.format.JsonDateTimeFormatter;
import io.trino.plugin.kafka.encoder.json.format.util.TimeConversions;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.assertions.Assert;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestMillisecondsJsonDateTimeFormatter {
    private static JsonDateTimeFormatter getFormatter() {
        return DateTimeFormat.MILLISECONDS_SINCE_EPOCH.getFormatter(Optional.empty());
    }

    @Test(dataProvider="testTimeProvider")
    public void testTime(LocalTime time) {
        String formatted = TestMillisecondsJsonDateTimeFormatter.getFormatter().formatTime(DateTimeTestingUtils.sqlTimeOf((int)3, (LocalTime)time), 3);
        Assert.assertEquals((long)Long.parseLong(formatted), (long)time.getLong(ChronoField.MILLI_OF_DAY));
    }

    @DataProvider
    public Object[][] testTimeProvider() {
        return new Object[][]{{LocalTime.of(15, 36, 25, 123000000)}, {LocalTime.of(15, 36, 25, 0)}};
    }

    @Test(dataProvider="testTimestampProvider")
    public void testTimestamp(LocalDateTime dateTime) {
        String formattedStr = TestMillisecondsJsonDateTimeFormatter.getFormatter().formatTimestamp(DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)dateTime));
        Assert.assertEquals((long)Long.parseLong(formattedStr), (long)(TimeUnit.DAYS.toMillis(dateTime.getLong(ChronoField.EPOCH_DAY)) + TimeConversions.scaleNanosToMillis((long)dateTime.getLong(ChronoField.NANO_OF_DAY))));
    }

    @DataProvider
    public Object[][] testTimestampProvider() {
        return new Object[][]{{LocalDateTime.of(2020, 8, 18, 12, 38, 29, 123000000)}, {LocalDateTime.of(1970, 1, 1, 0, 0, 0, 0)}, {LocalDateTime.of(1800, 8, 18, 12, 38, 29, 123000000)}};
    }

    @Test(dataProvider="testTimestampWithTimeZoneProvider")
    public void testTimestampWithTimeZone(ZonedDateTime zonedDateTime) {
        String formattedStr = TestMillisecondsJsonDateTimeFormatter.getFormatter().formatTimestampWithZone(SqlTimestampWithTimeZone.fromInstant((int)3, (Instant)zonedDateTime.toInstant(), (ZoneId)zonedDateTime.getZone()));
        Assert.assertEquals((long)Long.parseLong(formattedStr), (long)zonedDateTime.toInstant().toEpochMilli());
    }

    @DataProvider
    public Object[][] testTimestampWithTimeZoneProvider() {
        return new Object[][]{{ZonedDateTime.of(2020, 8, 18, 12, 38, 29, 123000000, TimeZoneKey.UTC_KEY.getZoneId())}, {ZonedDateTime.of(2020, 8, 18, 12, 38, 29, 123000000, TimeZoneKey.getTimeZoneKey((String)"America/New_York").getZoneId())}, {ZonedDateTime.of(1800, 8, 18, 12, 38, 29, 123000000, TimeZoneKey.UTC_KEY.getZoneId())}, {ZonedDateTime.of(2020, 8, 18, 12, 38, 29, 123000000, TimeZoneKey.getTimeZoneKey((String)"Asia/Hong_Kong").getZoneId())}, {ZonedDateTime.of(2020, 8, 18, 12, 38, 29, 123000000, TimeZoneKey.getTimeZoneKey((String)"Africa/Mogadishu").getZoneId())}, {ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, TimeZoneKey.UTC_KEY.getZoneId())}};
    }
}

