/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.kafka.KafkaColumnHandle;
import io.trino.plugin.kafka.encoder.json.JsonRowEncoderFactory;
import io.trino.plugin.kafka.encoder.json.format.DateTimeFormat;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.testng.annotations.Test;

public class TestJsonEncoder {
    private static final ConnectorSession SESSION = TestingConnectorSession.builder().build();
    private static final JsonRowEncoderFactory ENCODER_FACTORY = new JsonRowEncoderFactory(new ObjectMapper());

    private static void assertUnsupportedColumnTypeException(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Unsupported column type .* for column .*");
    }

    private static void assertUnsupportedDataFormatException(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Unsupported or no dataFormat .* defined for temporal column .*");
    }

    private static void assertSupportedDataType(EmptyFunctionalInterface functionalInterface) {
        functionalInterface.apply();
    }

    private static void singleColumnEncoder(Type type) {
        ENCODER_FACTORY.create(SESSION, Optional.empty(), (List)ImmutableList.of((Object)new KafkaColumnHandle("default", type, "default", null, null, false, false, false)));
    }

    private static void singleColumnEncoder(Type type, DateTimeFormat dataFormat, String formatHint) {
        Objects.requireNonNull(dataFormat, "dataFormat is null");
        if (dataFormat.equals((Object)DateTimeFormat.CUSTOM_DATE_TIME)) {
            ENCODER_FACTORY.create(SESSION, Optional.empty(), (List)ImmutableList.of((Object)new KafkaColumnHandle("default", type, "default", dataFormat.toString(), formatHint, false, false, false)));
        } else {
            ENCODER_FACTORY.create(SESSION, Optional.empty(), (List)ImmutableList.of((Object)new KafkaColumnHandle("default", type, "default", dataFormat.toString(), null, false, false, false)));
        }
    }

    @Test
    public void testColumnValidation() {
        TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)BigintType.BIGINT));
        TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)IntegerType.INTEGER));
        TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)SmallintType.SMALLINT));
        TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)TinyintType.TINYINT));
        TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)DoubleType.DOUBLE));
        TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)BooleanType.BOOLEAN));
        TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)VarcharType.createVarcharType((int)20)));
        TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)VarcharType.createUnboundedVarcharType()));
        TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)TimestampType.TIMESTAMP, DateTimeFormat.RFC2822, ""));
        TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, DateTimeFormat.RFC2822, ""));
        for (DateTimeFormat dataFormat : ImmutableList.of((Object)DateTimeFormat.CUSTOM_DATE_TIME, (Object)DateTimeFormat.ISO8601)) {
            TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)DateType.DATE, dataFormat, "yyyy-dd-MM"));
            TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)TimeType.TIME, dataFormat, "kk:mm:ss.SSS"));
            TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, dataFormat, "kk:mm:ss.SSS Z"));
            TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)TimestampType.TIMESTAMP, dataFormat, "yyyy-dd-MM kk:mm:ss.SSS"));
            TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, dataFormat, "yyyy-dd-MM kk:mm:ss.SSS Z"));
        }
        for (DateTimeFormat dataFormat : ImmutableList.of((Object)DateTimeFormat.MILLISECONDS_SINCE_EPOCH, (Object)DateTimeFormat.SECONDS_SINCE_EPOCH)) {
            TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)TimeType.TIME, dataFormat, null));
            TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)TimestampType.TIMESTAMP, dataFormat, null));
            TestJsonEncoder.assertSupportedDataType(() -> TestJsonEncoder.singleColumnEncoder((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, dataFormat, null));
        }
        TestJsonEncoder.assertUnsupportedColumnTypeException(() -> TestJsonEncoder.singleColumnEncoder((Type)RealType.REAL));
        TestJsonEncoder.assertUnsupportedColumnTypeException(() -> TestJsonEncoder.singleColumnEncoder((Type)DecimalType.createDecimalType((int)10, (int)4)));
        TestJsonEncoder.assertUnsupportedColumnTypeException(() -> TestJsonEncoder.singleColumnEncoder((Type)VarbinaryType.VARBINARY));
        TestJsonEncoder.assertUnsupportedDataFormatException(() -> TestJsonEncoder.singleColumnEncoder((Type)DateType.DATE));
        TestJsonEncoder.assertUnsupportedDataFormatException(() -> TestJsonEncoder.singleColumnEncoder((Type)TimeType.TIME));
        TestJsonEncoder.assertUnsupportedDataFormatException(() -> TestJsonEncoder.singleColumnEncoder((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE));
        TestJsonEncoder.assertUnsupportedDataFormatException(() -> TestJsonEncoder.singleColumnEncoder((Type)TimestampType.TIMESTAMP));
        TestJsonEncoder.assertUnsupportedDataFormatException(() -> TestJsonEncoder.singleColumnEncoder((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE));
        for (DateTimeFormat dataFormat : ImmutableList.of((Object)DateTimeFormat.MILLISECONDS_SINCE_EPOCH, (Object)DateTimeFormat.SECONDS_SINCE_EPOCH)) {
            TestJsonEncoder.assertUnsupportedColumnTypeException(() -> TestJsonEncoder.singleColumnEncoder((Type)DateType.DATE, dataFormat, null));
        }
    }

    @FunctionalInterface
    static interface EmptyFunctionalInterface {
        public void apply();
    }
}

