/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json;

import io.trino.plugin.kafka.encoder.json.format.DateTimeFormat;
import io.trino.plugin.kafka.encoder.json.format.JsonDateTimeFormatter;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.assertions.Assert;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestISO8601JsonDateTimeFormatter {
    private static JsonDateTimeFormatter getFormatter() {
        return DateTimeFormat.ISO8601.getFormatter(Optional.empty());
    }

    private static void testDate(SqlDate value, String expectedLiteral) {
        String actualLiteral = TestISO8601JsonDateTimeFormatter.getFormatter().formatDate(value);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    private static void testTime(SqlTime value, int precision, String expectedLiteral) {
        String actualLiteral = TestISO8601JsonDateTimeFormatter.getFormatter().formatTime(value, precision);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    private static void testTimeWithTZ(SqlTimeWithTimeZone value, String expectedLiteral) {
        String actualLiteral = TestISO8601JsonDateTimeFormatter.getFormatter().formatTimeWithZone(value);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    private static void testTimestamp(SqlTimestamp value, String expectedLiteral) {
        String actualLiteral = TestISO8601JsonDateTimeFormatter.getFormatter().formatTimestamp(value);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    private static void testTimestampWithTZ(SqlTimestampWithTimeZone value, String expectedLiteral) {
        String actualLiteral = TestISO8601JsonDateTimeFormatter.getFormatter().formatTimestampWithZone(value);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    @Test
    public void testISO8601DateTimeFunctions() {
        TestISO8601JsonDateTimeFormatter.testDate(DateTimeTestingUtils.sqlDateOf((int)2020, (int)8, (int)14), "2020-08-14");
        TestISO8601JsonDateTimeFormatter.testDate(DateTimeTestingUtils.sqlDateOf((int)1970, (int)1, (int)1), "1970-01-01");
        TestISO8601JsonDateTimeFormatter.testDate(DateTimeTestingUtils.sqlDateOf((int)1900, (int)1, (int)1), "1900-01-01");
        TestISO8601JsonDateTimeFormatter.testDate(DateTimeTestingUtils.sqlDateOf((int)3001, (int)1, (int)1), "3001-01-01");
        TestISO8601JsonDateTimeFormatter.testTime(DateTimeTestingUtils.sqlTimeOf((int)3, (int)15, (int)36, (int)25, (int)123000000), 3, "15:36:25.123");
        TestISO8601JsonDateTimeFormatter.testTime(DateTimeTestingUtils.sqlTimeOf((int)3, (int)15, (int)36, (int)25, (int)0), 3, "15:36:25");
        TestISO8601JsonDateTimeFormatter.testTime(DateTimeTestingUtils.sqlTimeOf((int)3, (int)8, (int)12, (int)45, (int)987000000), 3, "08:12:45.987");
        TestISO8601JsonDateTimeFormatter.testTime(DateTimeTestingUtils.sqlTimeOf((int)3, (int)0, (int)0, (int)0, (int)0), 3, "00:00");
        TestISO8601JsonDateTimeFormatter.testTime(DateTimeTestingUtils.sqlTimeOf((int)3, (int)23, (int)59, (int)59, (int)999000000), 3, "23:59:59.999");
        TestISO8601JsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)10, (int)23, (int)35, (int)123000000, (int)0), "10:23:35.123Z");
        TestISO8601JsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)0, (int)0, (int)0, (int)0, (int)0), "00:00:00Z");
        TestISO8601JsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)10, (int)23, (int)35, (int)123000000, (int)120), "10:23:35.123+02:00");
        TestISO8601JsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)10, (int)23, (int)35, (int)123000000, (int)600), "10:23:35.123+10:00");
        TestISO8601JsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)10, (int)23, (int)35, (int)123000000, (int)-600), "10:23:35.123-10:00");
        TestISO8601JsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)23, (int)59, (int)59, (int)999000000, (int)0), "23:59:59.999Z");
        TestISO8601JsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)12, (int)34, (int)56, (int)789000000, (int)-35), "12:34:56.789-00:35");
        TestISO8601JsonDateTimeFormatter.testTimestamp(DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2020, (int)8, (int)18, (int)12, (int)38, (int)29, (int)123), "2020-08-18T12:38:29.123");
        TestISO8601JsonDateTimeFormatter.testTimestamp(DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0), "1970-01-01T00:00");
        TestISO8601JsonDateTimeFormatter.testTimestamp(DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1800, (int)8, (int)18, (int)12, (int)38, (int)29, (int)123), "1800-08-18T12:38:29.123");
        TestISO8601JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)123000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), "2020-08-19T12:23:41.123Z");
        TestISO8601JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"America/New_York")), "2020-08-19T12:23:41.123-04:00");
        TestISO8601JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)1800, (int)8, (int)19, (int)12, (int)23, (int)41, (int)123000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), "1800-08-19T12:23:41.123Z");
        TestISO8601JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Asia/Hong_Kong")), "2020-08-19T12:23:41.123+08:00");
        TestISO8601JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Africa/Mogadishu")), "2020-08-19T12:23:41.123+03:00");
        TestISO8601JsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), "1970-01-01T00:00:00Z");
    }
}

