/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder.json;

import io.trino.plugin.kafka.encoder.json.format.DateTimeFormat;
import io.trino.plugin.kafka.encoder.json.format.JsonDateTimeFormatter;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.assertions.Assert;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestCustomJsonDateTimeFormatter {
    private static JsonDateTimeFormatter getFormatter(String formatHint) {
        return DateTimeFormat.CUSTOM_DATE_TIME.getFormatter(Optional.of(formatHint));
    }

    private static void testDate(SqlDate value, String formatHint, String expectedLiteral) {
        String actualLiteral = TestCustomJsonDateTimeFormatter.getFormatter(formatHint).formatDate(value);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    private static void testTime(SqlTime value, String formatHint, int precision, String expectedLiteral) {
        String actualLiteral = TestCustomJsonDateTimeFormatter.getFormatter(formatHint).formatTime(value, precision);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    private static void testTimeWithTZ(SqlTimeWithTimeZone value, String formatHint, String expectedLiteral) {
        String actualLiteral = TestCustomJsonDateTimeFormatter.getFormatter(formatHint).formatTimeWithZone(value);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    private static void testTimestamp(SqlTimestamp value, String formatHint, String expectedLiteral) {
        String actualLiteral = TestCustomJsonDateTimeFormatter.getFormatter(formatHint).formatTimestamp(value);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    private static void testTimestampWithTZ(SqlTimestampWithTimeZone value, String formatHint, String expectedLiteral) {
        String actualLiteral = TestCustomJsonDateTimeFormatter.getFormatter(formatHint).formatTimestampWithZone(value);
        Assert.assertEquals((String)actualLiteral, (String)expectedLiteral);
    }

    @Test
    public void testCustomDateTimeFunctions() {
        TestCustomJsonDateTimeFormatter.testDate(DateTimeTestingUtils.sqlDateOf((int)2020, (int)8, (int)14), "yyyy-MM-dd", "2020-08-14");
        TestCustomJsonDateTimeFormatter.testDate(DateTimeTestingUtils.sqlDateOf((int)1970, (int)1, (int)1), "yyyy-MM-dd", "1970-01-01");
        TestCustomJsonDateTimeFormatter.testDate(DateTimeTestingUtils.sqlDateOf((int)1900, (int)1, (int)1), "yyyy-MM-dd", "1900-01-01");
        TestCustomJsonDateTimeFormatter.testDate(DateTimeTestingUtils.sqlDateOf((int)3001, (int)1, (int)1), "yyyy-MM-dd", "3001-01-01");
        TestCustomJsonDateTimeFormatter.testTime(DateTimeTestingUtils.sqlTimeOf((int)3, (int)15, (int)36, (int)25, (int)123000000), "HH:mm:ss.SSS", 3, "15:36:25.123");
        TestCustomJsonDateTimeFormatter.testTime(DateTimeTestingUtils.sqlTimeOf((int)3, (int)15, (int)36, (int)25, (int)0), "HH:mm:ss", 3, "15:36:25");
        TestCustomJsonDateTimeFormatter.testTime(DateTimeTestingUtils.sqlTimeOf((int)3, (int)8, (int)12, (int)45, (int)987000000), "HH:mm:ss.SSS", 3, "08:12:45.987");
        TestCustomJsonDateTimeFormatter.testTime(DateTimeTestingUtils.sqlTimeOf((int)3, (int)0, (int)0, (int)0, (int)0), "HH:mm:ss.SSS", 3, "00:00:00.000");
        TestCustomJsonDateTimeFormatter.testTime(DateTimeTestingUtils.sqlTimeOf((int)3, (int)23, (int)59, (int)59, (int)999000000), "HH:mm:ss.SSS", 3, "23:59:59.999");
        TestCustomJsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)10, (int)23, (int)35, (int)123000000, (int)0), "HH:mm:ss.SSS Z", "10:23:35.123 +0000");
        TestCustomJsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)0, (int)0, (int)0, (int)0, (int)0), "HH:mm:ss.SSS Z", "00:00:00.000 +0000");
        TestCustomJsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)10, (int)23, (int)35, (int)123000000, (int)120), "HH:mm:ss.SSS Z", "10:23:35.123 +0200");
        TestCustomJsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)10, (int)23, (int)35, (int)123000000, (int)600), "HH:mm:ss.SSS Z", "10:23:35.123 +1000");
        TestCustomJsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)10, (int)23, (int)35, (int)123000000, (int)-600), "HH:mm:ss.SSS Z", "10:23:35.123 -1000");
        TestCustomJsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)23, (int)59, (int)59, (int)999000000, (int)0), "HH:mm:ss.SSS Z", "23:59:59.999 +0000");
        TestCustomJsonDateTimeFormatter.testTimeWithTZ(DateTimeTestingUtils.sqlTimeWithTimeZoneOf((int)3, (int)12, (int)34, (int)56, (int)789000000, (int)-35), "HH:mm:ss.SSS Z", "12:34:56.789 -0035");
        TestCustomJsonDateTimeFormatter.testTimestamp(DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2020, (int)8, (int)18, (int)12, (int)38, (int)29, (int)123), "yyyy-dd-MM HH:mm:ss.SSS", "2020-18-08 12:38:29.123");
        TestCustomJsonDateTimeFormatter.testTimestamp(DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0), "yyyy-dd-MM HH:mm:ss.SSS", "1970-01-01 00:00:00.000");
        TestCustomJsonDateTimeFormatter.testTimestamp(DateTimeTestingUtils.sqlTimestampOf((int)3, (int)1800, (int)8, (int)18, (int)12, (int)38, (int)29, (int)123), "yyyy-dd-MM HH:mm:ss.SSS", "1800-18-08 12:38:29.123");
        TestCustomJsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)123000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), "yyyy-dd-MM HH:mm:ss.SSS Z", "2020-19-08 12:23:41.123 +0000");
        TestCustomJsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"America/New_York")), "yyyy-dd-MM HH:mm:ss.SSS Z", "2020-19-08 12:23:41.123 -0400");
        TestCustomJsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)1800, (int)8, (int)19, (int)12, (int)23, (int)41, (int)123000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), "yyyy-dd-MM HH:mm:ss.SSS Z", "1800-19-08 12:23:41.123 +0000");
        TestCustomJsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Asia/Hong_Kong")), "yyyy-dd-MM HH:mm:ss.SSS Z", "2020-19-08 12:23:41.123 +0800");
        TestCustomJsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)2020, (int)8, (int)19, (int)12, (int)23, (int)41, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Africa/Mogadishu")), "yyyy-dd-MM HH:mm:ss.SSS Z", "2020-19-08 12:23:41.123 +0300");
        TestCustomJsonDateTimeFormatter.testTimestampWithTZ(DateTimeTestingUtils.sqlTimestampWithTimeZoneOf((int)3, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), "yyyy-dd-MM HH:mm:ss.SSS Z", "1970-01-01 00:00:00.000 +0000");
    }
}

