/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableMap;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.kafka.KafkaQueryRunner;
import io.trino.plugin.kafka.KafkaTopicDescription;
import io.trino.plugin.kafka.util.TestUtils;
import io.trino.spi.connector.SchemaTableName;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.kafka.TestingKafka;
import java.util.Map;
import java.util.UUID;
import java.util.stream.LongStream;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMinimalFunctionality
extends AbstractTestQueryFramework {
    private TestingKafka testingKafka;
    private String topicName;

    protected QueryRunner createQueryRunner() throws Exception {
        this.testingKafka = (TestingKafka)this.closeAfterClass((AutoCloseable)TestingKafka.create());
        this.topicName = "test_" + UUID.randomUUID().toString().replaceAll("-", "_");
        DistributedQueryRunner queryRunner = KafkaQueryRunner.builder(this.testingKafka).setExtraTopicDescription((Map<SchemaTableName, KafkaTopicDescription>)ImmutableMap.builder().put(TestUtils.createEmptyTopicDescription(this.topicName, new SchemaTableName("default", this.topicName))).buildOrThrow()).setExtraKafkaProperties((Map<String, String>)ImmutableMap.builder().put((Object)"kafka.messages-per-split", (Object)"100").buildOrThrow()).build();
        return queryRunner;
    }

    @Test
    public void testTopicExists() {
        Assert.assertTrue((boolean)this.getQueryRunner().listTables(this.getSession(), "kafka", "default").contains(QualifiedObjectName.valueOf((String)("kafka.default." + this.topicName))));
    }

    @Test
    public void testTopicHasData() {
        this.assertQuery("SELECT count(*) FROM default." + this.topicName, "VALUES 0");
        this.testingKafka.sendMessages(LongStream.range(0L, 100000L).mapToObj(id -> new ProducerRecord(this.topicName, (Object)id, (Object)ImmutableMap.of((Object)"id", (Object)Long.toString(id), (Object)"value", (Object)UUID.randomUUID().toString()))));
        this.assertQuery("SELECT count(*) FROM default." + this.topicName, "VALUES 100000L");
    }
}

