/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableMap;
import com.google.inject.ConfigurationException;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.kafka.security.KafkaEndpointIdentificationAlgorithm;
import io.trino.plugin.kafka.security.KafkaKeystoreTruststoreType;
import io.trino.plugin.kafka.security.KafkaSslConfig;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestKafkaSslConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((KafkaSslConfig)ConfigAssertions.recordDefaults(KafkaSslConfig.class)).setKeystoreLocation(null).setKeystorePassword(null).setKeystoreType(KafkaKeystoreTruststoreType.JKS).setTruststoreLocation(null).setTruststorePassword(null).setTruststoreType(KafkaKeystoreTruststoreType.JKS).setKeyPassword(null).setEndpointIdentificationAlgorithm(KafkaEndpointIdentificationAlgorithm.HTTPS));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        String secret = "confluent";
        Path keystorePath = Files.createTempFile("keystore", ".p12", new FileAttribute[0]);
        Path truststorePath = Files.createTempFile("truststore", ".p12", new FileAttribute[0]);
        this.writeToFile(keystorePath, secret);
        this.writeToFile(truststorePath, secret);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"kafka.ssl.keystore.location", (Object)keystorePath.toString()).put((Object)"kafka.ssl.keystore.password", (Object)"keystore-password").put((Object)"kafka.ssl.keystore.type", (Object)"PKCS12").put((Object)"kafka.ssl.truststore.location", (Object)truststorePath.toString()).put((Object)"kafka.ssl.truststore.password", (Object)"truststore-password").put((Object)"kafka.ssl.truststore.type", (Object)"PKCS12").put((Object)"kafka.ssl.key.password", (Object)"key-password").put((Object)"kafka.ssl.endpoint-identification-algorithm", (Object)"disabled").buildOrThrow();
        KafkaSslConfig expected = new KafkaSslConfig().setKeystoreLocation(keystorePath.toString()).setKeystorePassword("keystore-password").setKeystoreType(KafkaKeystoreTruststoreType.PKCS12).setTruststoreLocation(truststorePath.toString()).setTruststorePassword("truststore-password").setTruststoreType(KafkaKeystoreTruststoreType.PKCS12).setKeyPassword("key-password").setEndpointIdentificationAlgorithm(KafkaEndpointIdentificationAlgorithm.DISABLED);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testAllConfigPropertiesAreContained() {
        KafkaSslConfig config = new KafkaSslConfig().setKeystoreLocation("/some/path/to/keystore").setKeystorePassword("superSavePasswordForKeystore").setKeystoreType(KafkaKeystoreTruststoreType.JKS).setTruststoreLocation("/some/path/to/truststore").setTruststorePassword("superSavePasswordForTruststore").setTruststoreType(KafkaKeystoreTruststoreType.JKS).setKeyPassword("aSslKeyPassword").setEndpointIdentificationAlgorithm(KafkaEndpointIdentificationAlgorithm.HTTPS);
        Map securityProperties = config.getKafkaClientProperties();
        Assertions.assertThat((Map)securityProperties).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.copyOf(Map.of("ssl.keystore.location", "/some/path/to/keystore", "ssl.keystore.password", "superSavePasswordForKeystore", "ssl.keystore.type", KafkaKeystoreTruststoreType.JKS.name(), "ssl.truststore.location", "/some/path/to/truststore", "ssl.truststore.password", "superSavePasswordForTruststore", "ssl.truststore.type", KafkaKeystoreTruststoreType.JKS.name(), "ssl.key.password", "aSslKeyPassword", "security.protocol", SecurityProtocol.SSL.name(), "ssl.endpoint.identification.algorithm", KafkaEndpointIdentificationAlgorithm.HTTPS.getValue())));
    }

    @Test
    public void testDisabledEndpointIdentificationAlgorithm() {
        KafkaSslConfig config = new KafkaSslConfig();
        if (KafkaEndpointIdentificationAlgorithm.fromString((String)"disabled").isPresent()) {
            config.setEndpointIdentificationAlgorithm((KafkaEndpointIdentificationAlgorithm)KafkaEndpointIdentificationAlgorithm.fromString((String)"disabled").get());
        }
        Map securityProperties = config.getKafkaClientProperties();
        Assertions.assertThat((Map)securityProperties).containsKey((Object)"ssl.endpoint.identification.algorithm");
        Assertions.assertThat(securityProperties.get("ssl.endpoint.identification.algorithm")).isEqualTo((Object)"");
    }

    @Test
    public void testFailOnMissingKeystorePasswordWithKeystoreLocationSet() throws Exception {
        String secret = "confluent";
        Path keystorePath = Files.createTempFile("keystore", ".p12", new FileAttribute[0]);
        this.writeToFile(keystorePath, secret);
        KafkaSslConfig config = new KafkaSslConfig();
        config.setKeystoreLocation(keystorePath.toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((KafkaSslConfig)config).validate()).isInstanceOf(ConfigurationException.class)).hasMessageContaining("kafka.ssl.keystore.password must set when kafka.ssl.keystore.location is given");
    }

    @Test
    public void testFailOnMissingTruststorePasswordWithTruststoreLocationSet() throws Exception {
        String secret = "confluent";
        Path truststorePath = Files.createTempFile("truststore", ".p12", new FileAttribute[0]);
        this.writeToFile(truststorePath, secret);
        KafkaSslConfig config = new KafkaSslConfig();
        config.setTruststoreLocation(truststorePath.toString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((KafkaSslConfig)config).validate()).isInstanceOf(ConfigurationException.class)).hasMessageContaining("kafka.ssl.truststore.password must set when kafka.ssl.truststore.location is given");
    }

    private void writeToFile(Path filepath, String content) throws IOException {
        try (FileWriter writer = new FileWriter(filepath.toFile(), StandardCharsets.UTF_8);){
            writer.write(content);
        }
    }
}

