/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.kafka.KafkaSecurityConfig;
import java.util.Map;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestKafkaSecurityConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((KafkaSecurityConfig)ConfigAssertions.recordDefaults(KafkaSecurityConfig.class)).setSecurityProtocol(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"kafka.security-protocol", (Object)"SSL").buildOrThrow();
        KafkaSecurityConfig expected = new KafkaSecurityConfig().setSecurityProtocol(SecurityProtocol.SSL);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test(dataProvider="validSecurityProtocols")
    public void testValidSecurityProtocols(SecurityProtocol securityProtocol) {
        new KafkaSecurityConfig().setSecurityProtocol(securityProtocol).validate();
    }

    @DataProvider(name="validSecurityProtocols")
    public Object[][] validSecurityProtocols() {
        return new Object[][]{{SecurityProtocol.PLAINTEXT}, {SecurityProtocol.SSL}};
    }

    @Test(dataProvider="invalidSecurityProtocols")
    public void testInvalidSecurityProtocol(SecurityProtocol securityProtocol) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new KafkaSecurityConfig().setSecurityProtocol(securityProtocol).validate()).isInstanceOf(IllegalStateException.class)).hasMessage("Only PLAINTEXT and SSL security protocols are supported. See 'kafka.config.resources' if other security protocols are needed");
    }

    @DataProvider(name="invalidSecurityProtocols")
    public Object[][] invalidSecurityProtocols() {
        return new Object[][]{{SecurityProtocol.SASL_PLAINTEXT}, {SecurityProtocol.SASL_SSL}};
    }
}

