/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.plugin.kafka.KafkaConnectorFactory;
import io.trino.plugin.kafka.KafkaPlugin;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.TestingConnectorContext;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestKafkaPlugin {
    @Test
    public void testSpinup() throws IOException {
        KafkaPlugin plugin = new KafkaPlugin();
        ConnectorFactory factory = (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
        io.airlift.testing.Assertions.assertInstanceOf((Object)factory, KafkaConnectorFactory.class);
        Path resource = Files.createTempFile("kafka", ".properties", new FileAttribute[0]);
        Connector connector = factory.create("test-connector", (Map)ImmutableMap.builder().put((Object)"kafka.table-names", (Object)"test").put((Object)"kafka.nodes", (Object)"localhost:9092").put((Object)"kafka.config.resources", (Object)resource.toString()).buildOrThrow(), (ConnectorContext)new TestingConnectorContext());
        Assert.assertNotNull((Object)connector);
        connector.shutdown();
    }

    @Test
    public void testSslSpinup() throws IOException {
        KafkaPlugin plugin = new KafkaPlugin();
        ConnectorFactory factory = (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
        io.airlift.testing.Assertions.assertInstanceOf((Object)factory, KafkaConnectorFactory.class);
        String secret = "confluent";
        Path keystorePath = Files.createTempFile("keystore", ".jks", new FileAttribute[0]);
        Path truststorePath = Files.createTempFile("truststore", ".jks", new FileAttribute[0]);
        this.writeToFile(keystorePath, secret);
        this.writeToFile(truststorePath, secret);
        Connector connector = factory.create("test-connector", (Map)ImmutableMap.builder().put((Object)"kafka.table-names", (Object)"test").put((Object)"kafka.nodes", (Object)"localhost:9092").put((Object)"kafka.security-protocol", (Object)"SSL").put((Object)"kafka.ssl.keystore.type", (Object)"JKS").put((Object)"kafka.ssl.keystore.location", (Object)keystorePath.toString()).put((Object)"kafka.ssl.keystore.password", (Object)"keystore-password").put((Object)"kafka.ssl.key.password", (Object)"key-password").put((Object)"kafka.ssl.truststore.type", (Object)"JKS").put((Object)"kafka.ssl.truststore.location", (Object)truststorePath.toString()).put((Object)"kafka.ssl.truststore.password", (Object)"truststore-password").put((Object)"kafka.ssl.endpoint-identification-algorithm", (Object)"https").buildOrThrow(), (ConnectorContext)new TestingConnectorContext());
        Assert.assertNotNull((Object)connector);
        connector.shutdown();
    }

    @Test
    public void testSslKeystoreMissingFileSpindown() throws IOException {
        KafkaPlugin plugin = new KafkaPlugin();
        ConnectorFactory factory = (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
        io.airlift.testing.Assertions.assertInstanceOf((Object)factory, KafkaConnectorFactory.class);
        Path truststorePath = Files.createTempFile("test", ".jks", new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> factory.create("test-connector", (Map)ImmutableMap.builder().put((Object)"kafka.table-names", (Object)"test").put((Object)"kafka.nodes", (Object)"localhost:9092").put((Object)"kafka.security-protocol", (Object)"SSL").put((Object)"kafka.ssl.keystore.type", (Object)"JKS").put((Object)"kafka.ssl.keystore.location", (Object)"/not/a/real/path").put((Object)"kafka.ssl.keystore.password", (Object)"keystore-password").put((Object)"kafka.ssl.key.password", (Object)"key-password").put((Object)"kafka.ssl.truststore.type", (Object)"JKS").put((Object)"kafka.ssl.truststore.location", (Object)truststorePath.toString()).put((Object)"kafka.ssl.truststore.password", (Object)"truststore-password").put((Object)"kafka.ssl.endpoint-identification-algorithm", (Object)"https").buildOrThrow(), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("Error: Invalid configuration property kafka.ssl.keystore.location: file does not exist: /not/a/real/path");
    }

    @Test
    public void testSslTruststoreMissingFileSpindown() throws IOException {
        KafkaPlugin plugin = new KafkaPlugin();
        ConnectorFactory factory = (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
        io.airlift.testing.Assertions.assertInstanceOf((Object)factory, KafkaConnectorFactory.class);
        Path keystorePath = Files.createTempFile("test", ".jks", new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> factory.create("test-connector", (Map)ImmutableMap.builder().put((Object)"kafka.table-names", (Object)"test").put((Object)"kafka.nodes", (Object)"localhost:9092").put((Object)"kafka.security-protocol", (Object)"SSL").put((Object)"kafka.ssl.keystore.type", (Object)"JKS").put((Object)"kafka.ssl.keystore.location", (Object)keystorePath.toString()).put((Object)"kafka.ssl.keystore.password", (Object)"keystore-password").put((Object)"kafka.ssl.key.password", (Object)"key-password").put((Object)"kafka.ssl.truststore.type", (Object)"JKS").put((Object)"kafka.ssl.truststore.location", (Object)"/not/a/real/path").put((Object)"kafka.ssl.truststore.password", (Object)"truststore-password").put((Object)"kafka.ssl.endpoint-identification-algorithm", (Object)"https").buildOrThrow(), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("Error: Invalid configuration property kafka.ssl.truststore.location: file does not exist: /not/a/real/path");
    }

    @Test
    public void testResourceConfigMissingFileSpindown() {
        KafkaPlugin plugin = new KafkaPlugin();
        ConnectorFactory factory = (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
        io.airlift.testing.Assertions.assertInstanceOf((Object)factory, KafkaConnectorFactory.class);
        Assertions.assertThatThrownBy(() -> factory.create("test-connector", (Map)ImmutableMap.builder().put((Object)"kafka.table-names", (Object)"test").put((Object)"kafka.nodes", (Object)"localhost:9092").put((Object)"kafka.security-protocol", (Object)"PLAINTEXT").put((Object)"kafka.config.resources", (Object)"/not/a/real/path/1,/not/a/real/path/2").buildOrThrow(), (ConnectorContext)new TestingConnectorContext())).hasMessageContainingAll(new CharSequence[]{"Error: Invalid configuration property", ": file does not exist: /not/a/real/path/1", ": file does not exist: /not/a/real/path/2"});
    }

    @Test
    public void testConfigResourceSpinup() throws IOException {
        KafkaPlugin plugin = new KafkaPlugin();
        ConnectorFactory factory = (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
        io.airlift.testing.Assertions.assertInstanceOf((Object)factory, KafkaConnectorFactory.class);
        String nativeContent = "security.protocol=" + SecurityProtocol.SSL;
        Path nativeKafkaResourcePath = Files.createTempFile("native_kafka", ".properties", new FileAttribute[0]);
        this.writeToFile(nativeKafkaResourcePath, nativeContent);
        Connector connector = factory.create("test-connector", (Map)ImmutableMap.builder().put((Object)"kafka.table-names", (Object)"test").put((Object)"kafka.nodes", (Object)"localhost:9092").put((Object)"kafka.config.resources", (Object)nativeKafkaResourcePath.toString()).buildOrThrow(), (ConnectorContext)new TestingConnectorContext());
        Assert.assertNotNull((Object)connector);
        connector.shutdown();
    }

    private void writeToFile(Path filepath, String content) throws IOException {
        try (FileWriter writer = new FileWriter(filepath.toFile(), StandardCharsets.UTF_8);){
            writer.write(content);
        }
    }
}

