/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.kafka.KafkaFilterManager;
import io.trino.plugin.kafka.Range;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestKafkaFilterManager {
    @Test
    public void testFilterValuesByDomain() {
        Set<Long> source = Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L), Long.valueOf(6L));
        Domain testDomain = Domain.singleValue((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertEquals((Set)KafkaFilterManager.filterValuesByDomain((Domain)testDomain, source), Set.of(Long.valueOf(1L)));
        testDomain = Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)3L, (Object)8L));
        Assert.assertEquals((Set)KafkaFilterManager.filterValuesByDomain((Domain)testDomain, source), Set.of(Long.valueOf(3L)));
        testDomain = Domain.create((ValueSet)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)io.trino.spi.predicate.Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)4L, (boolean)true))), (boolean)false);
        Assert.assertEquals((Set)KafkaFilterManager.filterValuesByDomain((Domain)testDomain, source), Set.of(Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L)));
    }

    @Test
    public void testFilterRangeByDomain() {
        Domain testDomain = Domain.singleValue((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertTrue((boolean)KafkaFilterManager.filterRangeByDomain((Domain)testDomain).isPresent());
        Assert.assertEquals((long)((Range)KafkaFilterManager.filterRangeByDomain((Domain)testDomain).get()).getBegin(), (long)1L);
        Assert.assertEquals((long)((Range)KafkaFilterManager.filterRangeByDomain((Domain)testDomain).get()).getEnd(), (long)2L);
        testDomain = Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)3L, (Object)8L));
        Assert.assertTrue((boolean)KafkaFilterManager.filterRangeByDomain((Domain)testDomain).isPresent());
        Assert.assertEquals((long)((Range)KafkaFilterManager.filterRangeByDomain((Domain)testDomain).get()).getBegin(), (long)3L);
        Assert.assertEquals((long)((Range)KafkaFilterManager.filterRangeByDomain((Domain)testDomain).get()).getEnd(), (long)9L);
        testDomain = Domain.create((ValueSet)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)io.trino.spi.predicate.Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)4L, (boolean)true))), (boolean)false);
        Assert.assertTrue((boolean)KafkaFilterManager.filterRangeByDomain((Domain)testDomain).isPresent());
        Assert.assertEquals((long)((Range)KafkaFilterManager.filterRangeByDomain((Domain)testDomain).get()).getBegin(), (long)2L);
        Assert.assertEquals((long)((Range)KafkaFilterManager.filterRangeByDomain((Domain)testDomain).get()).getEnd(), (long)5L);
    }
}

