/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.kafka.KafkaConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestKafkaConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((KafkaConfig)ConfigAssertions.recordDefaults(KafkaConfig.class)).setNodes("").setKafkaBufferSize("64kB").setDefaultSchema("default").setTableDescriptionSupplier("file").setHideInternalColumns(true).setMessagesPerSplit(100000).setTimestampUpperBoundPushDownEnabled(false).setResourceConfigFiles(List.of()));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path resource1 = Files.createTempFile(null, null, new FileAttribute[0]);
        Path resource2 = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"kafka.default-schema", (Object)"kafka").put((Object)"kafka.table-description-supplier", (Object)"test").put((Object)"kafka.nodes", (Object)"localhost:12345,localhost:23456").put((Object)"kafka.buffer-size", (Object)"1MB").put((Object)"kafka.hide-internal-columns", (Object)"false").put((Object)"kafka.messages-per-split", (Object)"1").put((Object)"kafka.timestamp-upper-bound-force-push-down-enabled", (Object)"true").put((Object)"kafka.config.resources", (Object)(resource1.toString() + "," + resource2.toString())).buildOrThrow();
        KafkaConfig expected = new KafkaConfig().setDefaultSchema("kafka").setTableDescriptionSupplier("test").setNodes("localhost:12345, localhost:23456").setKafkaBufferSize("1MB").setHideInternalColumns(false).setMessagesPerSplit(1).setTimestampUpperBoundPushDownEnabled(true).setResourceConfigFiles((List)ImmutableList.of((Object)resource1.toString(), (Object)resource2.toString()));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

