/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import io.airlift.log.Level;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.trino.plugin.kafka.KafkaPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.kafka.TestingKafka;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class KafkaQueryRunnerBuilder
extends DistributedQueryRunner.Builder<KafkaQueryRunnerBuilder> {
    protected final TestingKafka testingKafka;
    protected Map<String, String> extraKafkaProperties = ImmutableMap.of();
    protected Module extension = KafkaPlugin.DEFAULT_EXTENSION;

    public KafkaQueryRunnerBuilder(TestingKafka testingKafka, String defaultSessionSchema) {
        super(TestingSession.testSessionBuilder().setCatalog("kafka").setSchema(defaultSessionSchema).build());
        this.testingKafka = Objects.requireNonNull(testingKafka, "testingKafka is null");
    }

    public KafkaQueryRunnerBuilder setExtraKafkaProperties(Map<String, String> extraKafkaProperties) {
        this.extraKafkaProperties = ImmutableMap.copyOf(Objects.requireNonNull(extraKafkaProperties, "extraKafkaProperties is null"));
        return this;
    }

    public KafkaQueryRunnerBuilder setExtension(Module extension) {
        this.extension = Objects.requireNonNull(extension, "extension is null");
        return this;
    }

    public final DistributedQueryRunner build() throws Exception {
        Logging logging = Logging.initialize();
        logging.setLevel("org.apache.kafka", Level.WARN);
        DistributedQueryRunner queryRunner = super.build();
        try {
            this.testingKafka.start();
            this.preInit(queryRunner);
            queryRunner.installPlugin((Plugin)new KafkaPlugin(this.extension));
            HashMap<String, String> kafkaProperties = new HashMap<String, String>((Map<String, String>)ImmutableMap.copyOf(this.extraKafkaProperties));
            kafkaProperties.putIfAbsent("kafka.nodes", this.testingKafka.getConnectString());
            kafkaProperties.putIfAbsent("kafka.messages-per-split", "1000");
            queryRunner.createCatalog("kafka", "kafka", kafkaProperties);
            this.postInit(queryRunner);
            return queryRunner;
        }
        catch (RuntimeException e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    protected void preInit(DistributedQueryRunner queryRunner) throws Exception {
    }

    protected void postInit(DistributedQueryRunner queryRunner) {
    }
}

