/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.springhttpclient;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.configuration.TraceeFilterConfiguration;
import io.tracee.transport.HttpJsonHeaderTransport;
import io.tracee.transport.TransportSerialization;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public final class TraceeClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final TraceeBackend backend;
    private final TransportSerialization<String> transportSerialization;
    private final String profile;

    public TraceeClientHttpRequestInterceptor() {
        this(Tracee.getBackend(), (TransportSerialization<String>)new HttpJsonHeaderTransport(Tracee.getBackend().getLoggerFactory()), null);
    }

    public TraceeClientHttpRequestInterceptor(String profile) {
        this(Tracee.getBackend(), (TransportSerialization<String>)new HttpJsonHeaderTransport(Tracee.getBackend().getLoggerFactory()), profile);
    }

    protected TraceeClientHttpRequestInterceptor(TraceeBackend backend, TransportSerialization<String> transportSerialization, String profile) {
        this.backend = backend;
        this.transportSerialization = transportSerialization;
        this.profile = profile;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.preRequest(request);
        ClientHttpResponse response = execution.execute(request, body);
        this.postResponse(response);
        return response;
    }

    private void preRequest(HttpRequest request) {
        TraceeFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(TraceeFilterConfiguration.Channel.OutgoingRequest)) {
            Map filteredParams = filterConfiguration.filterDeniedParams((Map)this.backend, TraceeFilterConfiguration.Channel.OutgoingRequest);
            String contextAsHeader = (String)this.transportSerialization.render(filteredParams);
            request.getHeaders().add("TPIC", contextAsHeader);
        }
    }

    private void postResponse(ClientHttpResponse response) {
        TraceeFilterConfiguration filterConfiguration;
        List headers = response.getHeaders().get((Object)"TPIC");
        if (headers != null && (filterConfiguration = this.backend.getConfiguration(this.profile)).shouldProcessContext(TraceeFilterConfiguration.Channel.IncomingResponse)) {
            for (String header : headers) {
                Map parsedContext = this.transportSerialization.parse((Object)header);
                this.backend.putAll(filterConfiguration.filterDeniedParams(parsedContext, TraceeFilterConfiguration.Channel.IncomingResponse));
            }
        }
    }
}

