/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.lock;

import io.tlf.jme.jfx.lock.AsyncReadSyncWriteLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class AtomicReadWriteLock
implements AsyncReadSyncWriteLock,
Lock {
    private static final int STATUS_WRITE_LOCKED = 1;
    private static final int STATUS_WRITE_UNLOCKED = 0;
    private static final int STATUS_READ_UNLOCKED = 0;
    private static final int STATUS_READ_LOCKED = -200000;
    protected final AtomicInteger writeStatus;
    protected final AtomicInteger writeCount = new AtomicInteger(0);
    protected final AtomicInteger readCount;
    protected int sink = 1;

    public AtomicReadWriteLock() {
        this.writeStatus = new AtomicInteger(0);
        this.readCount = new AtomicInteger(0);
    }

    @Override
    public void asyncLock() {
        while (!this.tryReadLock()) {
            this.consumeCPU();
        }
    }

    @Override
    public void asyncUnlock() {
        this.readCount.decrementAndGet();
    }

    protected void consumeCPU() {
        int value = this.sink;
        int newValue = value * value;
        newValue += value >>> 1;
        newValue += value & newValue;
        newValue += value >>> 1;
        newValue += value & newValue;
        newValue += value >>> 1;
        newValue += value & newValue;
        this.sink = newValue;
    }

    @Override
    public void lock() {
        this.syncLock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void syncLock() {
        this.writeCount.incrementAndGet();
        while (this.tryToLockReading()) {
            this.consumeCPU();
        }
        while (this.tryToLockWriting()) {
            this.consumeCPU();
        }
    }

    protected boolean tryToLockWriting() {
        return this.writeStatus.get() != 0 || !this.writeStatus.compareAndSet(0, 1);
    }

    protected boolean tryToLockReading() {
        return this.readCount.get() != 0 || !this.readCount.compareAndSet(0, -200000);
    }

    @Override
    public void syncUnlock() {
        this.writeStatus.set(0);
        this.readCount.set(0);
        this.writeCount.decrementAndGet();
    }

    @Override
    public boolean tryLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    private boolean tryReadLock() {
        if (this.writeCount.get() != 0) {
            return false;
        }
        int value = this.readCount.get();
        return value != -200000 && this.readCount.compareAndSet(value, value + 1);
    }

    @Override
    public void unlock() {
        this.syncUnlock();
    }

    public String toString() {
        return "AtomicReadWriteLock{readCount=" + this.readCount + ", writeCount=" + this.writeCount + ", writeStatus=" + this.writeStatus + "}";
    }
}

