/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.injme.input;

import com.jme3.app.Application;
import com.jme3.input.InputManager;
import com.jme3.input.RawInputListener;
import com.jme3.input.awt.AwtKeyInput;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import io.tlf.jme.jfx.injme.JmeFxContainerInternal;
import io.tlf.jme.jfx.injme.JmeFxDnDHandler;
import io.tlf.jme.jfx.util.JfxPlatform;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.Function;
import javafx.scene.Scene;

public class JmeFXInputListener
implements RawInputListener {
    private final JmeFxContainerInternal container;
    private final BitSet keyStateSet;
    private final char[][] keyCharArray;
    private final char[] keyCharSet;
    private final boolean[] mouseButtonState;
    private volatile RawInputListener rawInputListener;
    private Function<InputEvent, Boolean> allowedToConsumeInputEventFunction = event -> true;
    private volatile JmeFxDnDHandler dndHandler;

    public JmeFXInputListener(JmeFxContainerInternal container) {
        this.container = container;
        this.keyStateSet = new BitSet(255);
        this.keyCharSet = new char[0x10FFFF];
        this.mouseButtonState = new boolean[3];
        this.keyCharArray = new char[0x10FFFF][];
        int length = this.keyCharArray.length;
        for (int i = 0; i < length; ++i) {
            this.keyCharArray[i] = new char[]{(char)i};
        }
    }

    private JmeFxDnDHandler getDNDHandler() {
        return this.dndHandler;
    }

    public void beginInput() {
        RawInputListener adapter = this.getRawInputListener();
        if (adapter != null) {
            adapter.beginInput();
        }
    }

    public void endInput() {
        RawInputListener adapter = this.getRawInputListener();
        if (adapter != null) {
            adapter.endInput();
        }
    }

    private RawInputListener getRawInputListener() {
        return this.rawInputListener;
    }

    private JmeFxContainerInternal getContainer() {
        return this.container;
    }

    private char[][] getKeyCharArray() {
        return this.keyCharArray;
    }

    private char[] getKeyCharSet() {
        return this.keyCharSet;
    }

    private BitSet getKeyStateSet() {
        return this.keyStateSet;
    }

    private boolean[] getMouseButtonState() {
        return this.mouseButtonState;
    }

    public void onJoyAxisEvent(JoyAxisEvent event) {
        RawInputListener adapter = this.getRawInputListener();
        if (adapter != null) {
            adapter.onJoyAxisEvent(event);
        }
    }

    public void onJoyButtonEvent(JoyButtonEvent event) {
        RawInputListener adapter = this.getRawInputListener();
        if (adapter != null) {
            adapter.onJoyButtonEvent(event);
        }
    }

    public void onKeyEvent(KeyInputEvent event) {
        JmeFxContainerInternal container;
        EmbeddedSceneInterface sceneInterface;
        RawInputListener adapter = this.getRawInputListener();
        if (adapter != null) {
            adapter.onKeyEvent(event);
        }
        if ((sceneInterface = (container = this.getContainer()).getSceneInterface()) == null) {
            return;
        }
        BitSet keyStateSet = this.getKeyStateSet();
        char[][] keyCharArray = this.getKeyCharArray();
        char[] keyCharSet = this.getKeyCharSet();
        char keyChar = event.getKeyChar();
        int keyCode = event.getKeyCode();
        int fxKeyCode = keyCode == 0 ? 0 : AwtKeyInput.convertJmeCode((int)keyCode);
        int keyState = this.retrieveKeyState();
        if (fxKeyCode > keyCharSet.length) {
            switch (keyChar) {
                case '\\': {
                    fxKeyCode = 92;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (container.isFocused() && this.allowedToConsumeInputEventFunction.apply((InputEvent)event).booleanValue()) {
            event.setConsumed();
        }
        if (event.isRepeating()) {
            char x = keyCharSet[fxKeyCode];
            if (container.isFocused()) {
                if (fxKeyCode == 8 || fxKeyCode == 10 || fxKeyCode == 39 || fxKeyCode == 37 || fxKeyCode == 38 || fxKeyCode == 40) {
                    sceneInterface.keyEvent(0, fxKeyCode, keyCharArray[x], keyState);
                    sceneInterface.keyEvent(2, fxKeyCode, keyCharArray[x], keyState);
                } else {
                    sceneInterface.keyEvent(2, fxKeyCode, keyCharArray[x], keyState);
                }
            }
        } else if (event.isPressed()) {
            keyCharSet[fxKeyCode] = keyChar;
            keyStateSet.set(fxKeyCode);
            if (container.isFocused()) {
                sceneInterface.keyEvent(0, fxKeyCode, keyCharArray[keyChar], keyState);
                sceneInterface.keyEvent(2, fxKeyCode, keyCharArray[keyChar], keyState);
            }
        } else {
            char x = keyCharSet[fxKeyCode];
            keyStateSet.clear(fxKeyCode);
            if (container.isFocused()) {
                sceneInterface.keyEvent(1, fxKeyCode, keyCharArray[x], keyState);
            }
        }
    }

    public void onMouseButtonEvent(MouseButtonEvent event) {
        int type;
        int button;
        RawInputListener adapter = this.getRawInputListener();
        if (adapter != null) {
            adapter.onMouseButtonEvent(event);
        }
        JmeFxContainerInternal container = this.getContainer();
        Application application = Objects.requireNonNull(container.getApplication());
        InputManager inputManager = application.getInputManager();
        if (container.getSceneInterface() == null) {
            return;
        }
        Scene scene = container.getScene();
        int x = event.getX();
        int y = (int)Math.round(scene.getHeight()) - event.getY();
        switch (event.getButtonIndex()) {
            case 0: {
                button = 1;
                break;
            }
            case 1: {
                button = 2;
                break;
            }
            case 2: {
                button = 4;
                break;
            }
            default: {
                return;
            }
        }
        this.mouseButtonState[event.getButtonIndex()] = event.isPressed();
        boolean covered = container.isCovered(x, y);
        if (!covered) {
            container.loseFocus();
        } else if (inputManager.isCursorVisible()) {
            if (this.allowedToConsumeInputEventFunction.apply((InputEvent)event).booleanValue()) {
                event.setConsumed();
            }
            container.grabFocus();
        }
        if (event.isPressed()) {
            type = 0;
        } else if (event.isReleased()) {
            type = 1;
        } else {
            return;
        }
        if (inputManager.isCursorVisible() || event.isReleased()) {
            JfxPlatform.runInFxThread(() -> this.onMouseButtonEventImpl(x, y, button, type));
        }
    }

    private void onMouseButtonEventImpl(int x, int y, int button, int type) {
        boolean[] mouseButtonState = this.getMouseButtonState();
        JmeFxDnDHandler dndHandler = this.getDNDHandler();
        boolean primaryBtnDown = mouseButtonState[0];
        boolean middleBtnDown = mouseButtonState[1];
        boolean secondaryBtnDown = mouseButtonState[2];
        if (dndHandler != null) {
            dndHandler.mouseUpdate(x, y, primaryBtnDown);
        }
        JmeFxContainerInternal container = this.getContainer();
        EmbeddedSceneInterface sceneInterface = Objects.requireNonNull(container.getSceneInterface());
        int screenX = container.getPositionX() + x;
        int screenY = container.getPositionY() + y;
        BitSet keyStateSet = this.getKeyStateSet();
        boolean shift = keyStateSet.get(16);
        boolean ctrl = keyStateSet.get(17);
        boolean alt = keyStateSet.get(18);
        boolean meta = keyStateSet.get(157);
        boolean popupTrigger = button == 2;
        sceneInterface.mouseEvent(type, button, primaryBtnDown, middleBtnDown, secondaryBtnDown, shift, ctrl, x, y, screenX, screenY, shift, ctrl, alt, meta, popupTrigger);
    }

    public void onMouseMotionEvent(MouseMotionEvent event) {
        int y;
        RawInputListener adapter = this.getRawInputListener();
        if (adapter != null) {
            adapter.onMouseMotionEvent(event);
        }
        JmeFxContainerInternal container = this.getContainer();
        Application application = container.getApplication();
        InputManager inputManager = application.getInputManager();
        if (container.getSceneInterface() == null) {
            return;
        }
        Scene scene = container.getScene();
        int x = event.getX();
        boolean covered = container.isCovered(x, y = (int)Math.round(scene.getHeight()) - event.getY());
        if (covered) {
            event.setConsumed();
        }
        boolean[] mouseButtonState = this.getMouseButtonState();
        int type = 5;
        int button = 0;
        int wheelRotation = (int)Math.round((double)event.getDeltaWheel() / -120.0);
        int wheelTotalRotation = event.getWheel();
        if (wheelRotation != 0) {
            type = 7;
            button = 0;
        } else if (mouseButtonState[0]) {
            type = 6;
            button = 1;
        } else if (mouseButtonState[1]) {
            type = 6;
            button = 2;
        } else if (mouseButtonState[2]) {
            type = 6;
            button = 4;
        }
        int finalType = type;
        int finalButton = button;
        if (inputManager.isCursorVisible()) {
            JfxPlatform.runInFxThread(() -> this.onMouseMotionEventImpl(x, y, wheelRotation, wheelTotalRotation, finalType, finalButton));
        }
    }

    private void onMouseMotionEventImpl(int x, int y, int wheelRotation, int wheelTotalRotation, int type, int button) {
        JmeFxContainerInternal container = this.getContainer();
        Application application = container.getApplication();
        InputManager inputManager = application.getInputManager();
        if (!inputManager.isCursorVisible()) {
            return;
        }
        JmeFxDnDHandler dndHandler = this.getDNDHandler();
        boolean[] mouseButtonState = this.getMouseButtonState();
        boolean primaryBtnDown = mouseButtonState[0];
        boolean middleBtnDown = mouseButtonState[1];
        boolean secondaryBtnDown = mouseButtonState[2];
        if (dndHandler != null) {
            dndHandler.mouseUpdate(x, y, primaryBtnDown);
        }
        EmbeddedSceneInterface sceneInterface = container.getSceneInterface();
        int screenX = container.getPositionX() + x;
        int screenY = container.getPositionY() + y;
        BitSet keyStateSet = this.getKeyStateSet();
        boolean shift = keyStateSet.get(16);
        boolean ctrl = keyStateSet.get(17);
        boolean alt = keyStateSet.get(18);
        boolean meta = keyStateSet.get(157);
        sceneInterface.mouseEvent(type, button, primaryBtnDown, middleBtnDown, secondaryBtnDown, shift, ctrl, x, y, screenX, screenY, shift, ctrl, alt, meta, false);
        double scrollX = 0.0;
        double totalScrollX = 1.0;
        double xMultiplier = 50.0;
        double scrollY = -wheelRotation;
        double totalScrollY = wheelTotalRotation;
        double yMultiplier = 60.0;
        boolean inertia = false;
        sceneInterface.scrollEvent(type, scrollX, scrollY, totalScrollX, totalScrollY, xMultiplier, yMultiplier, (double)x, (double)y, (double)screenX, (double)screenY, shift, ctrl, alt, meta, inertia);
    }

    public void onTouchEvent(TouchEvent event) {
        RawInputListener adapter = this.getRawInputListener();
        if (adapter != null) {
            adapter.onTouchEvent(event);
        }
    }

    private int retrieveKeyState() {
        int embedModifiers = 0;
        BitSet keyStateSet = this.getKeyStateSet();
        if (keyStateSet.get(16)) {
            embedModifiers |= 1;
        }
        if (keyStateSet.get(17)) {
            embedModifiers |= 2;
        }
        if (keyStateSet.get(18)) {
            embedModifiers |= 4;
        }
        if (keyStateSet.get(157)) {
            embedModifiers |= 8;
        }
        return embedModifiers;
    }

    public void setEverListeningRawInputListener(RawInputListener rawInputListenerAdapter) {
        this.rawInputListener = rawInputListenerAdapter;
    }

    public void setMouseDNDListener(JmeFxDnDHandler dndHandler) {
        assert (this.dndHandler == null || dndHandler == null) : "duplicate dnd handler register? ";
        this.dndHandler = dndHandler;
    }

    public void setAllowedToConsumeInputEventFunction(Function<InputEvent, Boolean> allowedToConsumeInputEventFunction) {
        this.allowedToConsumeInputEventFunction = allowedToConsumeInputEventFunction;
    }
}

