/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.injme.cursor;

import com.jme3.app.Application;
import com.jme3.asset.AssetManager;
import com.jme3.cursors.plugins.JmeCursor;
import com.jme3.input.InputManager;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.cursor.CursorType;
import io.tlf.jme.jfx.injme.cursor.CursorDisplayProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class JmeCursorProvider
implements CursorDisplayProvider {
    private static final Logger LOGGER = Logger.getLogger(JmeCursorProvider.class.getName());
    private final Map<CursorType, JmeCursor> cache = new ConcurrentHashMap<CursorType, JmeCursor>();
    private final AssetManager assetManager;
    private final InputManager inputManager;
    private final Application application;

    public JmeCursorProvider(Application application, AssetManager assetManager, InputManager inputManager) {
        this.assetManager = assetManager;
        this.inputManager = inputManager;
        this.application = application;
    }

    @Override
    public void prepare(CursorType cursorType) {
        JmeCursor jmeCursor = null;
        switch (cursorType) {
            case CROSSHAIR: {
                jmeCursor = (JmeCursor)this.assetManager.loadAsset("Interface/Cursor/aero_cross.cur");
                break;
            }
            case DEFAULT: {
                jmeCursor = (JmeCursor)this.assetManager.loadAsset("Interface/Cursor/aero_arrow.cur");
                break;
            }
            case E_RESIZE: 
            case H_RESIZE: 
            case W_RESIZE: {
                jmeCursor = (JmeCursor)this.assetManager.loadAsset("Interface/Cursor/aero_ew.cur");
                break;
            }
            case HAND: {
                jmeCursor = (JmeCursor)this.assetManager.loadAsset("Interface/Cursor/aero_link.cur");
                break;
            }
            case MOVE: {
                jmeCursor = (JmeCursor)this.assetManager.loadAsset("Interface/Cursor/aero_move.cur");
                break;
            }
            case NE_RESIZE: 
            case SW_RESIZE: {
                jmeCursor = (JmeCursor)this.assetManager.loadAsset("Interface/Cursor/aero_nesw.cur");
                break;
            }
            case NW_RESIZE: 
            case SE_RESIZE: {
                jmeCursor = (JmeCursor)this.assetManager.loadAsset("Interface/Cursor/aero_nwse.cur");
                break;
            }
            case N_RESIZE: 
            case V_RESIZE: 
            case S_RESIZE: {
                jmeCursor = (JmeCursor)this.assetManager.loadAsset("Interface/Cursor/aero_ns.cur");
                break;
            }
            case TEXT: {
                jmeCursor = (JmeCursor)this.assetManager.loadAsset("Interface/Cursor/aero_text.cur");
                break;
            }
            case WAIT: {
                jmeCursor = (JmeCursor)this.assetManager.loadAsset("Interface/Cursor/aero_busy.ani");
                break;
            }
        }
        if (jmeCursor != null) {
            this.cache.putIfAbsent(cursorType, jmeCursor);
        }
    }

    @Override
    public void show(CursorFrame cursorFrame) {
        JmeCursor toDisplay;
        CursorType cursorType = cursorFrame.getCursorType();
        if (this.cache.get(cursorType) == null) {
            LOGGER.warning("Unknown Cursor: " + cursorType);
            cursorType = CursorType.DEFAULT;
        }
        if ((toDisplay = this.cache.get(cursorType)) != null) {
            this.application.enqueue(() -> this.inputManager.setMouseCursor(toDisplay));
        }
    }
}

