/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.injme;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.input.InputManager;
import com.jme3.input.RawInputListener;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.JmeContext;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.ui.Picture;
import com.jme3.util.BufferUtils;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.cursor.CursorType;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.stage.EmbeddedWindow;
import io.tlf.jme.jfx.injme.JavaFxPicture;
import io.tlf.jme.jfx.injme.JmeFxContainer;
import io.tlf.jme.jfx.injme.JmeFxContainerInternal;
import io.tlf.jme.jfx.injme.JmeFxHostInterface;
import io.tlf.jme.jfx.injme.cursor.CursorDisplayProvider;
import io.tlf.jme.jfx.injme.cursor.JmeCursorProvider;
import io.tlf.jme.jfx.injme.input.JmeFXInputListener;
import io.tlf.jme.jfx.injme.util.JmeWindowUtils;
import io.tlf.jme.jfx.lock.AsyncReadSyncWriteLock;
import io.tlf.jme.jfx.lock.FinalAtomicReadWriteLock;
import io.tlf.jme.jfx.util.JfxPlatform;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Scene;

public class JmeFxContainerImpl
implements JmeFxContainer,
JmeFxContainerInternal {
    private static final Logger LOGGER = Logger.getLogger(JmeFxContainerImpl.class.getName());
    private static final int MIN_RESIZE_INTERVAL = 300;
    private final AppState fxAppState = new AbstractAppState(){

        public void cleanup() {
            Platform.exit();
            super.cleanup();
        }
    };
    protected volatile CompletableFuture<Image.Format> nativeFormat = new CompletableFuture();
    private final AtomicInteger waitCount;
    private final AsyncReadSyncWriteLock imageLock;
    private final Picture picture;
    private final Texture2D texture;
    private final JmeContext jmeContext;
    protected final Application application;
    protected final CursorDisplayProvider cursorProvider;
    protected final HostInterface hostInterface;
    protected volatile JmeFXInputListener inputListener;
    protected volatile EmbeddedStageInterface stageInterface;
    protected volatile EmbeddedSceneInterface sceneInterface;
    protected volatile EmbeddedWindow embeddedWindow;
    protected volatile Scene scene;
    protected volatile Group rootNode;
    protected volatile Image jmeImage;
    protected volatile ByteBuffer jmeData;
    protected volatile ByteBuffer fxData;
    protected volatile ByteBuffer tempData;
    protected volatile IntBuffer tempIntData;
    protected volatile Function<ByteBuffer, Void> reorderData;
    protected volatile long lastResized;
    protected volatile int sceneWidth;
    protected volatile int sceneHeight;
    protected volatile int positionX;
    protected volatile int positionY;
    protected volatile boolean focused;
    protected volatile boolean fullScreenSupport;
    protected volatile boolean visibleCursor;
    protected volatile boolean enabled;

    public static JmeFxContainerImpl install(Application application, Node guiNode) {
        return JmeFxContainerImpl.install(application, guiNode, new JmeCursorProvider(application, application.getAssetManager(), application.getInputManager()));
    }

    public static JmeFxContainerImpl install(Application application, Node guiNode, CursorDisplayProvider cursorProvider) {
        JmeFxContainerImpl container = new JmeFxContainerImpl(application.getAssetManager(), application, cursorProvider);
        guiNode.attachChild((Spatial)container.getJmeNode());
        InputManager inputManager = application.getInputManager();
        inputManager.addRawInputListener((RawInputListener)container.getInputListener());
        return container;
    }

    private static Void reorder_ARGB82ABGR8(ByteBuffer data) {
        int limit = data.limit() - 3;
        for (int i = 0; i < limit; i += 4) {
            byte v = data.get(i + 1);
            data.put(i + 1, data.get(i + 3));
            data.put(i + 3, v);
        }
        return null;
    }

    private static Void reorder_BGRA82ABGR8(ByteBuffer data) {
        int limit = data.limit() - 3;
        for (int i = 0; i < limit; i += 4) {
            byte v0 = data.get(i);
            byte v1 = data.get(i + 1);
            byte v2 = data.get(i + 2);
            byte v3 = data.get(i + 3);
            data.put(i, v3);
            data.put(i + 1, v0);
            data.put(i + 2, v1);
            data.put(i + 3, v2);
        }
        return null;
    }

    protected JmeFxContainerImpl(AssetManager assetManager, Application application, CursorDisplayProvider cursorProvider) {
        this.initFx();
        this.positionY = -1;
        this.positionX = -1;
        this.jmeContext = application.getContext();
        this.waitCount = new AtomicInteger();
        this.imageLock = new FinalAtomicReadWriteLock();
        this.cursorProvider = cursorProvider;
        for (CursorType type : CursorType.values()) {
            cursorProvider.prepare(type);
        }
        this.application = application;
        this.visibleCursor = true;
        this.inputListener = new JmeFXInputListener(this);
        AppStateManager stateManager = application.getStateManager();
        stateManager.attach(this.fxAppState);
        this.hostInterface = new JmeFxHostInterface(this);
        this.picture = new JavaFxPicture(this);
        this.picture.move(0.0f, 0.0f, -1.0f);
        this.picture.setPosition(0.0f, 0.0f);
        this.texture = new Texture2D(new Image());
        this.picture.setTexture(assetManager, this.texture, true);
        this.fitSceneToWindowSize();
    }

    @Override
    public void requestPreferredSize(int width, int height) {
    }

    @Override
    public boolean requestFocus() {
        return true;
    }

    private void setLastResized(long time) {
        this.lastResized = time;
    }

    private long getLastResized() {
        return this.lastResized;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public JmeContext getJmeContext() {
        return this.jmeContext;
    }

    @Override
    public CursorDisplayProvider getCursorProvider() {
        return this.cursorProvider;
    }

    private AsyncReadSyncWriteLock getImageLock() {
        return this.imageLock;
    }

    @Override
    public JmeFXInputListener getInputListener() {
        return this.inputListener;
    }

    private Image getJmeImage() {
        return this.jmeImage;
    }

    private Picture getJmeNode() {
        return this.picture;
    }

    @Override
    public int getPositionX() {
        return this.positionX;
    }

    @Override
    public void setPositionX(int positionX) {
        this.positionX = positionX;
    }

    @Override
    public int getPositionY() {
        return this.positionY;
    }

    @Override
    public void setPositionY(int positionY) {
        this.positionY = positionY;
    }

    private Picture getPicture() {
        return this.picture;
    }

    @Override
    public int getSceneHeight() {
        return this.sceneHeight;
    }

    @Override
    public void setSceneHeight(int sceneHeight) {
        this.sceneHeight = sceneHeight;
    }

    @Override
    public int getSceneWidth() {
        return this.sceneWidth;
    }

    @Override
    public void setSceneWidth(int sceneWidth) {
        this.sceneWidth = sceneWidth;
    }

    @Override
    public float getPixelScaleFactor() {
        return 1.0f;
    }

    private Function<ByteBuffer, Void> getReorderData() {
        return this.reorderData;
    }

    @Override
    public Group getRootNode() {
        return this.rootNode;
    }

    @Override
    public Scene getScene() {
        return this.scene;
    }

    @Override
    public EmbeddedSceneInterface getSceneInterface() {
        return this.sceneInterface;
    }

    @Override
    public void setSceneInterface(EmbeddedSceneInterface sceneInterface) {
        this.sceneInterface = sceneInterface;
    }

    @Override
    public EmbeddedWindow getEmbeddedWindow() {
        return this.embeddedWindow;
    }

    @Override
    public void setEmbeddedWindow(EmbeddedWindow embeddedWindow) {
        this.embeddedWindow = embeddedWindow;
    }

    @Override
    public EmbeddedStageInterface getStageInterface() {
        return this.stageInterface;
    }

    @Override
    public void setStageInterface(EmbeddedStageInterface stageInterface) {
        this.stageInterface = stageInterface;
    }

    private ByteBuffer getFxData() {
        return this.fxData;
    }

    private ByteBuffer getJmeData() {
        return this.jmeData;
    }

    private ByteBuffer getTempData() {
        return this.tempData;
    }

    private IntBuffer getTempIntData() {
        return this.tempIntData;
    }

    private Texture2D getTexture() {
        return this.texture;
    }

    private AtomicInteger getWaitCount() {
        return this.waitCount;
    }

    @Override
    public void grabFocus() {
        EmbeddedStageInterface stageInterface = this.getStageInterface();
        if (this.isFocused() || stageInterface == null) {
            return;
        }
        stageInterface.setFocused(true, 0);
        this.setFocused(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fitSceneToWindowSize() {
        long time = System.currentTimeMillis();
        if (time - this.getLastResized() < 300L) {
            return;
        }
        JmeContext jmeContext = this.getJmeContext();
        int winWidth = JmeWindowUtils.getWidth(jmeContext);
        int winHeight = JmeWindowUtils.getHeight(jmeContext);
        AsyncReadSyncWriteLock lock = this.getImageLock();
        lock.syncLock();
        try {
            Image jmeImage;
            ByteBuffer jmeData;
            ByteBuffer tempData;
            int textureWidth = Math.max(winWidth, 64);
            int textureHeight = Math.max(winHeight, 64);
            Picture picture = this.getPicture();
            picture.setWidth((float)textureWidth);
            picture.setHeight((float)textureHeight);
            ByteBuffer fxData = this.getFxData();
            if (fxData != null) {
                BufferUtils.destroyDirectBuffer((Buffer)fxData);
            }
            if ((tempData = this.getTempData()) != null) {
                BufferUtils.destroyDirectBuffer((Buffer)tempData);
            }
            if ((jmeData = this.getJmeData()) != null) {
                BufferUtils.destroyDirectBuffer((Buffer)jmeData);
            }
            if ((jmeImage = this.getJmeImage()) != null) {
                jmeImage.dispose();
            }
            this.fxData = BufferUtils.createByteBuffer((int)(textureWidth * textureHeight * 4));
            this.tempData = BufferUtils.createByteBuffer((int)(textureWidth * textureHeight * 4));
            this.tempIntData = this.getTempData().asIntBuffer();
            this.jmeData = BufferUtils.createByteBuffer((int)(textureWidth * textureHeight * 4));
            this.jmeImage = new Image(this.nativeFormat.get(), textureWidth, textureHeight, this.getJmeData(), ColorSpace.sRGB);
            Texture2D texture = this.getTexture();
            texture.setImage(this.getJmeImage());
            this.setSceneHeight(textureHeight);
            this.setSceneWidth(textureWidth);
            EmbeddedStageInterface stageInterface = this.getStageInterface();
            EmbeddedSceneInterface sceneInterface = this.getSceneInterface();
            if (stageInterface != null && sceneInterface != null) {
                JfxPlatform.runInFxThread(() -> {
                    stageInterface.setSize(textureWidth, textureHeight);
                    sceneInterface.setSize(textureWidth, textureHeight);
                    this.hostInterface.repaint();
                });
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, null, e);
        }
        finally {
            lock.syncUnlock();
        }
        this.setLastResized(time);
    }

    @Override
    public void move(int positionX, int positionY) {
        this.setPositionX(positionX);
        this.setPositionY(positionY);
        EmbeddedStageInterface stageInterface = this.getStageInterface();
        if (stageInterface == null) {
            return;
        }
        JfxPlatform.runInFxThread(() -> stageInterface.setLocation(this.getPositionX(), this.getPositionY()));
    }

    private void initFx() {
        Platform.startup(() -> {
            switch (Pixels.getNativeFormat()) {
                case 2: {
                    try {
                        this.nativeFormat.complete(Image.Format.ARGB8);
                        this.reorderData = null;
                    }
                    catch (Exception exc1) {
                        this.nativeFormat.complete(Image.Format.ABGR8);
                        this.reorderData = JmeFxContainerImpl::reorder_ARGB82ABGR8;
                    }
                    break;
                }
                case 1: {
                    try {
                        this.nativeFormat.complete(Image.Format.BGRA8);
                        this.reorderData = null;
                    }
                    catch (Exception exc2) {
                        this.nativeFormat.complete(Image.Format.ABGR8);
                        this.reorderData = JmeFxContainerImpl::reorder_BGRA82ABGR8;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not supported javaFX pixel format " + Pixels.getNativeFormat());
                }
            }
        });
        Platform.setImplicitExit((boolean)false);
    }

    @Override
    public boolean isCovered(int x, int y) {
        Image jmeImage = this.getJmeImage();
        int sceneWidth = this.getSceneWidth();
        if (jmeImage == null || x < 0 || x >= sceneWidth) {
            return false;
        }
        if (y < 0 || y >= this.getSceneHeight()) {
            return false;
        }
        ByteBuffer data = jmeImage.getData(0);
        data.limit(data.capacity());
        byte alpha = data.get(3 + 4 * (y * sceneWidth + x));
        data.limit(0);
        return alpha != 0;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    private void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFullScreenSupport() {
        return this.fullScreenSupport;
    }

    @Override
    public boolean isNeedWriteToJme() {
        return this.waitCount.get() > 0;
    }

    public boolean isVisibleCursor() {
        return this.visibleCursor;
    }

    public void setVisibleCursor(boolean visibleCursor) {
        this.visibleCursor = visibleCursor;
    }

    @Override
    public void loseFocus() {
        EmbeddedStageInterface stagePeer = this.getStageInterface();
        if (!this.isFocused() || stagePeer == null) {
            return;
        }
        stagePeer.setFocused(false, 3);
        this.setFocused(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestRedraw() {
        EmbeddedSceneInterface sceneInterface = this.getSceneInterface();
        if (sceneInterface == null) {
            return;
        }
        ByteBuffer tempData = this.getTempData();
        tempData.clear();
        int sceneWidth = this.getSceneWidth();
        int sceneHeight = this.getSceneHeight();
        if (!sceneInterface.getPixels(this.getTempIntData(), sceneWidth, sceneHeight)) {
            return;
        }
        tempData.flip();
        tempData.limit(sceneWidth * sceneHeight * 4);
        AsyncReadSyncWriteLock imageLock = this.getImageLock();
        imageLock.syncLock();
        try {
            ByteBuffer fxData = this.getFxData();
            fxData.clear();
            fxData.put(tempData);
            fxData.flip();
            Function<ByteBuffer, Void> reorderData = this.getReorderData();
            if (reorderData != null) {
                reorderData.apply(fxData);
                fxData.position(0);
            }
        }
        catch (Exception exc) {
            LOGGER.log(Level.WARNING, null, exc);
        }
        finally {
            imageLock.syncUnlock();
        }
        AtomicInteger waitCount = this.getWaitCount();
        waitCount.incrementAndGet();
    }

    @Override
    public void setScene(Scene newScene, Group rootNode) {
        this.rootNode = rootNode;
        this.rootNode.getStyleClass().add((Object)"root");
        JfxPlatform.runInFxThread(() -> this.setSceneImpl(newScene));
    }

    private void setSceneImpl(Scene newScene) {
        if (this.embeddedWindow != null && newScene == null) {
            this.embeddedWindow.hide();
            this.embeddedWindow = null;
        }
        Application application = this.getApplication();
        application.enqueue(() -> {
            this.picture.setCullHint(newScene == null ? Spatial.CullHint.Always : Spatial.CullHint.Never);
            return null;
        });
        this.scene = newScene;
        if (this.embeddedWindow == null && newScene != null) {
            this.embeddedWindow = new EmbeddedWindow(this.hostInterface);
        }
        if (this.embeddedWindow == null) {
            return;
        }
        this.embeddedWindow.setScene(newScene);
        if (!this.embeddedWindow.isShowing()) {
            this.embeddedWindow.show();
        }
    }

    @Override
    public void requestShowingCursor(CursorFrame cursorFrame) {
        this.cursorProvider.show(cursorFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void writeToJme() {
        AtomicInteger waitCount = this.getWaitCount();
        int currentCount = waitCount.get();
        ByteBuffer jmeData = this.getJmeData();
        jmeData.clear();
        AsyncReadSyncWriteLock imageLock = this.getImageLock();
        imageLock.syncLock();
        try {
            jmeData.put(this.getFxData());
        }
        finally {
            imageLock.syncUnlock();
        }
        jmeData.flip();
        Image jmeImage = this.getJmeImage();
        jmeImage.setUpdateNeeded();
        waitCount.set(waitCount.get() - currentCount);
        return null;
    }

    @Override
    public void requestEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

