/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.injfx.transfer.impl;

import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import io.tlf.jme.jfx.injfx.processor.FrameTransferSceneProcessor;
import io.tlf.jme.jfx.injfx.transfer.FrameTransfer;
import io.tlf.jme.jfx.util.JfxPlatform;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritablePixelFormat;

public abstract class AbstractFrameTransfer<T>
implements FrameTransfer {
    protected static final int RUNNING_STATE = 1;
    protected static final int WAITING_STATE = 2;
    protected static final int DISPOSING_STATE = 3;
    protected static final int DISPOSED_STATE = 4;
    protected final AtomicInteger frameState;
    protected final AtomicInteger imageState;
    protected final FrameBuffer frameBuffer;
    protected final PixelWriter pixelWriter;
    protected final ByteBuffer frameByteBuffer;
    protected final FrameTransferSceneProcessor.TransferMode transferMode;
    protected final byte[] byteBuffer;
    protected final byte[] imageByteBuffer;
    protected final byte[] prevImageByteBuffer;
    protected int frameCount;
    private final int width;
    private final int height;

    public AbstractFrameTransfer(T destination, int width, int height, FrameTransferSceneProcessor.TransferMode transferMode) {
        this(destination, transferMode, null, width, height);
    }

    public AbstractFrameTransfer(T destination, FrameTransferSceneProcessor.TransferMode transferMode, FrameBuffer frameBuffer, int width, int height) {
        this.transferMode = transferMode;
        this.frameState = new AtomicInteger(2);
        this.imageState = new AtomicInteger(2);
        this.width = frameBuffer != null ? frameBuffer.getWidth() : width;
        this.height = frameBuffer != null ? frameBuffer.getHeight() : height;
        this.frameCount = 0;
        if (frameBuffer != null) {
            this.frameBuffer = frameBuffer;
        } else {
            this.frameBuffer = new FrameBuffer(width, height, 1);
            this.frameBuffer.setDepthTarget(FrameBuffer.FrameBufferTarget.newTarget((Image.Format)Image.Format.Depth));
            this.frameBuffer.addColorTarget(FrameBuffer.FrameBufferTarget.newTarget((Image.Format)Image.Format.RGBA8));
            this.frameBuffer.setSrgb(true);
        }
        this.frameByteBuffer = BufferUtils.createByteBuffer((int)(this.getWidth() * this.getHeight() * 4));
        this.byteBuffer = new byte[this.getWidth() * this.getHeight() * 4];
        this.prevImageByteBuffer = new byte[this.getWidth() * this.getHeight() * 4];
        this.imageByteBuffer = new byte[this.getWidth() * this.getHeight() * 4];
        this.pixelWriter = this.getPixelWriter(destination, this.frameBuffer, width, height);
    }

    @Override
    public void initFor(Renderer renderer, boolean main) {
        if (main) {
            renderer.setMainFrameBufferOverride(this.frameBuffer);
        }
    }

    protected PixelWriter getPixelWriter(T destination, FrameBuffer frameBuffer, int width, int height) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFrameBufferToImage(RenderManager renderManager) {
        while (!this.frameState.compareAndSet(2, 1)) {
            if (this.frameState.get() != 4) continue;
            return;
        }
        try {
            this.frameByteBuffer.clear();
            Renderer renderer = renderManager.getRenderer();
            renderer.readFrameBufferWithFormat(this.frameBuffer, this.frameByteBuffer, Image.Format.RGBA8);
        }
        finally {
            if (!this.frameState.compareAndSet(1, 2)) {
                throw new RuntimeException("unknown problem with the frame state");
            }
        }
        byte[] byArray = this.byteBuffer;
        synchronized (this.byteBuffer) {
            this.frameByteBuffer.get(this.byteBuffer);
            if (this.transferMode == FrameTransferSceneProcessor.TransferMode.ON_CHANGES) {
                byte[] prevBuffer = this.getPrevImageByteBuffer();
                if (Arrays.equals(prevBuffer, this.byteBuffer)) {
                    if (this.frameCount == 0) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                } else {
                    this.frameCount = 2;
                    System.arraycopy(this.byteBuffer, 0, prevBuffer, 0, this.byteBuffer.length);
                }
                this.frameByteBuffer.position(0);
                --this.frameCount;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            JfxPlatform.runInFxThread(this::writeFrame);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFrame() {
        while (!this.imageState.compareAndSet(2, 1)) {
            if (this.imageState.get() != 4) continue;
            return;
        }
        try {
            byte[] imageByteBuffer = this.getImageByteBuffer();
            byte[] byArray = this.byteBuffer;
            synchronized (this.byteBuffer) {
                System.arraycopy(this.byteBuffer, 0, imageByteBuffer, 0, this.byteBuffer.length);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                int length = this.width * this.height * 4;
                for (int i = 0; i < length; i += 4) {
                    byte r = imageByteBuffer[i];
                    byte g = imageByteBuffer[i + 1];
                    byte b = imageByteBuffer[i + 2];
                    byte a = imageByteBuffer[i + 3];
                    imageByteBuffer[i] = b;
                    imageByteBuffer[i + 1] = g;
                    imageByteBuffer[i + 2] = r;
                    imageByteBuffer[i + 3] = a;
                }
                WritablePixelFormat pixelFormat = PixelFormat.getByteBgraInstance();
                this.pixelWriter.setPixels(0, 0, this.width, this.height, (PixelFormat)pixelFormat, imageByteBuffer, 0, this.width * 4);
            }
        }
        finally {
            if (!this.imageState.compareAndSet(1, 2)) {
                throw new RuntimeException("unknown problem with the image state");
            }
        }
        {
            return;
        }
    }

    protected byte[] getImageByteBuffer() {
        return this.imageByteBuffer;
    }

    protected byte[] getPrevImageByteBuffer() {
        return this.prevImageByteBuffer;
    }

    @Override
    public void dispose() {
        while (!this.frameState.compareAndSet(2, 3)) {
        }
        while (!this.imageState.compareAndSet(2, 3)) {
        }
        this.disposeImpl();
        this.frameState.compareAndSet(3, 4);
        this.imageState.compareAndSet(3, 4);
    }

    protected void disposeImpl() {
        this.frameBuffer.dispose();
        BufferUtils.destroyDirectBuffer((Buffer)this.frameByteBuffer);
    }
}

