/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.injfx.input;

import com.jme3.cursors.plugins.JmeCursor;
import com.jme3.input.MouseInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import io.tlf.jme.jfx.injfx.JmeOffscreenSurfaceContext;
import io.tlf.jme.jfx.injfx.input.JfxInput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;

public class JfxMouseInput
extends JfxInput
implements MouseInput {
    public static final String PROP_USE_LOCAL_COORDS = "JFX.mouseInput.useLocalCoords";
    public static final String PROP_INVERSE_Y_COORD = "JFX.mouseInput.inverseYCoord";
    private static final Map<MouseButton, Integer> MOUSE_BUTTON_TO_JME = new HashMap<MouseButton, Integer>();
    private static final int WHEEL_SCALE = 10;
    private final EventHandler<MouseEvent> processMotion = this::processMotion;
    private final EventHandler<MouseEvent> processPressed = this::processPressed;
    private final EventHandler<MouseEvent> processReleased = this::processReleased;
    private final EventHandler<ScrollEvent> processScroll = this::processScroll;
    private final LinkedList<MouseMotionEvent> mouseMotionEvents = new LinkedList();
    private final LinkedList<MouseButtonEvent> mouseButtonEvents = new LinkedList();
    private int mouseX;
    private int mouseY;
    private int mouseWheel;
    private boolean useLocalCoords;
    private boolean inverseYCoord;

    public JfxMouseInput(JmeOffscreenSurfaceContext context) {
        super(context);
    }

    @Override
    public void bind(Node node) {
        super.bind(node);
        node.addEventHandler(MouseEvent.MOUSE_MOVED, this.processMotion);
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.processPressed);
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, this.processReleased);
        node.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.processMotion);
        node.addEventHandler(ScrollEvent.ANY, this.processScroll);
        ObservableMap properties = node.getProperties();
        this.useLocalCoords = properties.get((Object)PROP_USE_LOCAL_COORDS) == Boolean.TRUE;
        this.inverseYCoord = properties.get((Object)PROP_INVERSE_Y_COORD) == Boolean.TRUE;
    }

    @Override
    public void unbind() {
        if (this.hasNode()) {
            Node node = this.getNode();
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.processMotion);
            node.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.processMotion);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.processPressed);
            node.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.processReleased);
            node.removeEventHandler(ScrollEvent.ANY, this.processScroll);
        }
        super.unbind();
    }

    @Override
    protected void updateImpl() {
        RawInputListener listener = this.getListener();
        while (!this.mouseMotionEvents.isEmpty()) {
            listener.onMouseMotionEvent(this.mouseMotionEvents.poll());
        }
        while (!this.mouseButtonEvents.isEmpty()) {
            listener.onMouseButtonEvent(this.mouseButtonEvents.poll());
        }
    }

    private void processScroll(ScrollEvent mouseEvent) {
        this.onWheelScroll(mouseEvent.getDeltaX() * 10.0, mouseEvent.getDeltaY() * 10.0);
    }

    private void processReleased(MouseEvent mouseEvent) {
        this.onMouseButton(mouseEvent.getButton(), false);
    }

    private void processPressed(MouseEvent mouseEvent) {
        this.onMouseButton(mouseEvent.getButton(), true);
    }

    private void processMotion(MouseEvent mouseEvent) {
        double sceneX = mouseEvent.getSceneX();
        double sceneY = mouseEvent.getSceneY();
        if (!this.useLocalCoords) {
            this.onCursorPos(sceneX, sceneY);
        } else {
            Point2D point2D = this.getNode().sceneToLocal(sceneX, sceneY, true);
            this.onCursorPos(point2D.getX(), point2D.getY());
        }
    }

    private void onWheelScroll(double xOffset, double yOffset) {
        this.mouseWheel = (int)((double)this.mouseWheel + yOffset);
        MouseMotionEvent mouseMotionEvent = new MouseMotionEvent(this.mouseX, this.mouseY, 0, 0, this.mouseWheel, (int)Math.round(yOffset));
        mouseMotionEvent.setTime(this.getInputTimeNanos());
        EXECUTOR.addToExecute(() -> this.mouseMotionEvents.add(mouseMotionEvent));
    }

    private void onCursorPos(double xpos, double ypos) {
        int x = (int)Math.round(xpos);
        int y = 0;
        if (this.inverseYCoord) {
            if (this.node instanceof Region) {
                y = (int)Math.round(((Region)this.node).getHeight() - ypos);
            } else if (this.node instanceof Canvas) {
                y = (int)Math.round(((Canvas)this.node).getHeight() - ypos);
            } else if (this.node instanceof ImageView) {
                y = (int)Math.round(((ImageView)this.node).getFitHeight() - ypos);
            }
        } else {
            y = (int)Math.round(ypos);
        }
        if (this.mouseX == 0) {
            this.mouseX = x;
        }
        if (this.mouseY == 0) {
            this.mouseY = y;
        }
        int xDelta = x - this.mouseX;
        int yDelta = y - this.mouseY;
        this.mouseX = x;
        this.mouseY = y;
        if (xDelta == 0 && yDelta == 0) {
            return;
        }
        MouseMotionEvent mouseMotionEvent = new MouseMotionEvent(x, y, xDelta, yDelta, this.mouseWheel, 0);
        mouseMotionEvent.setTime(this.getInputTimeNanos());
        EXECUTOR.addToExecute(() -> this.mouseMotionEvents.add(mouseMotionEvent));
    }

    private void onMouseButton(MouseButton button, boolean pressed) {
        MouseButtonEvent mouseButtonEvent = new MouseButtonEvent(this.convertButton(button), pressed, this.mouseX, this.mouseY);
        mouseButtonEvent.setTime(this.getInputTimeNanos());
        EXECUTOR.addToExecute(() -> this.mouseButtonEvents.add(mouseButtonEvent));
    }

    private int convertButton(MouseButton button) {
        Integer result = MOUSE_BUTTON_TO_JME.get(button);
        return result == null ? 0 : result;
    }

    public void setCursorVisible(boolean visible) {
    }

    public int getButtonCount() {
        return 3;
    }

    public void setNativeCursor(JmeCursor cursor) {
    }

    static {
        MOUSE_BUTTON_TO_JME.put(MouseButton.PRIMARY, 0);
        MOUSE_BUTTON_TO_JME.put(MouseButton.SECONDARY, 1);
        MOUSE_BUTTON_TO_JME.put(MouseButton.MIDDLE, 2);
    }
}

