/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.injfx;

import com.jme3.input.JoyInput;
import com.jme3.input.TouchInput;
import com.jme3.opencl.Context;
import com.jme3.renderer.Renderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import io.tlf.jme.jfx.injfx.input.JfxKeyInput;
import io.tlf.jme.jfx.injfx.input.JfxMouseInput;

public class JmeOffscreenSurfaceContext
implements JmeContext {
    protected final AppSettings settings;
    protected final JfxKeyInput keyInput = new JfxKeyInput(this);
    protected final JfxMouseInput mouseInput = new JfxMouseInput(this);
    private volatile int width = 1;
    private volatile int height = 1;
    protected JmeContext backgroundContext;

    public JmeOffscreenSurfaceContext() {
        this.settings = this.createSettings();
        this.backgroundContext = this.createBackgroundContext();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    protected AppSettings createSettings() {
        AppSettings settings = new AppSettings(true);
        settings.setRenderer("LWJGL-OpenGL3");
        return settings;
    }

    protected JmeContext createBackgroundContext() {
        return JmeSystem.newContext((AppSettings)this.settings, (JmeContext.Type)JmeContext.Type.OffscreenSurface);
    }

    protected JmeContext getBackgroundContext() {
        return this.backgroundContext;
    }

    public JmeContext.Type getType() {
        return JmeContext.Type.OffscreenSurface;
    }

    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
        this.settings.setRenderer("LWJGL-OpenGL3");
        this.getBackgroundContext().setSettings(settings);
    }

    public void setSystemListener(SystemListener listener) {
        this.getBackgroundContext().setSystemListener(listener);
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public Renderer getRenderer() {
        return this.getBackgroundContext().getRenderer();
    }

    public Context getOpenCLContext() {
        return null;
    }

    public JfxMouseInput getMouseInput() {
        return this.mouseInput;
    }

    public JfxKeyInput getKeyInput() {
        return this.keyInput;
    }

    public JoyInput getJoyInput() {
        return null;
    }

    public TouchInput getTouchInput() {
        return null;
    }

    public Timer getTimer() {
        return this.getBackgroundContext().getTimer();
    }

    public void setTitle(String title) {
    }

    public boolean isCreated() {
        return this.backgroundContext != null && this.backgroundContext.isCreated();
    }

    public boolean isRenderable() {
        return this.backgroundContext != null && this.backgroundContext.isRenderable();
    }

    public void setAutoFlushFrames(boolean enabled) {
    }

    public void create(boolean waitFor) {
        String render = System.getProperty("jfx.background.render", "LWJGL-OpenGL3");
        JmeContext backgroundContext = this.getBackgroundContext();
        backgroundContext.getSettings().setRenderer(render);
        backgroundContext.create(waitFor);
    }

    public void restart() {
    }

    public void destroy(boolean waitFor) {
        if (this.backgroundContext == null) {
            throw new IllegalStateException("Not created");
        }
        this.backgroundContext.destroy(waitFor);
    }
}

