/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.input.RawInputListener;
import com.jme3.renderer.Camera;
import io.tlf.jme.jfx.JmeFxEventConsumeAllowedFunction;
import io.tlf.jme.jfx.JmeMemoryInputHandler;
import io.tlf.jme.jfx.impl.JmeUpdateLoop;
import io.tlf.jme.jfx.impl.SceneNotifier;
import io.tlf.jme.jfx.injme.JmeFxContainer;
import io.tlf.jme.jfx.injme.JmeFxContainerImpl;
import io.tlf.jme.jfx.util.JfxPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JavaFxUI {
    private static final Logger LOGGER = Logger.getLogger(JavaFxUI.class.getName());
    private static JavaFxUI INSTANCE;
    private static boolean installAdapter;
    private final Application app;
    private JmeFxContainerImpl container;
    private final Group group;
    private Scene scene = null;
    private final AnchorPane uiscene;
    private final AnchorPane dialogAnchorPanel;
    private Node dialog;
    private ChangeListener<Bounds> dialogBoundsListener;
    private final List<JmeUpdateLoop> updatingItems = new ArrayList<JmeUpdateLoop>();
    private int camWidth;
    private int camHeight;

    private JavaFxUI(Application application, boolean installAdapter, String ... cssStyles) {
        this.app = application;
        com.jme3.scene.Node guiNode = ((SimpleApplication)application).getGuiNode();
        if (installAdapter) {
            this.container = (JmeFxContainerImpl)JmeFxContainer.install(application, guiNode);
        }
        this.group = new Group();
        this.uiscene = new AnchorPane();
        this.uiscene.setMinWidth((double)this.app.getCamera().getWidth());
        this.uiscene.setMinHeight((double)this.app.getCamera().getHeight());
        this.group.getChildren().add((Object)this.uiscene);
        if (!installAdapter) {
            this.uiscene.setPickOnBounds(false);
            this.group.setPickOnBounds(false);
        }
        if (installAdapter) {
            this.scene = new Scene((Parent)this.group, (double)this.app.getCamera().getWidth(), (double)this.app.getCamera().getHeight());
            this.scene.setFill((Paint)Color.TRANSPARENT);
            if (cssStyles != null) {
                this.scene.getStylesheets().addAll((Object[])cssStyles);
            }
            this.container.setScene(this.scene, this.group);
        }
        this.dialogAnchorPanel = new AnchorPane();
        this.dialogAnchorPanel.setMinWidth((double)this.app.getCamera().getWidth());
        this.dialogAnchorPanel.setMinHeight((double)this.app.getCamera().getHeight());
        this.camWidth = application.getCamera().getWidth();
        this.camHeight = application.getCamera().getHeight();
        if (installAdapter) {
            application.getStateManager().attach((AppState)new JavaFxUpdater());
            JmeMemoryInputHandler memoryInputHandler = new JmeMemoryInputHandler();
            this.app.getInputManager().addRawInputListener((RawInputListener)memoryInputHandler);
            JmeFxEventConsumeAllowedFunction allowedFunction = new JmeFxEventConsumeAllowedFunction(memoryInputHandler);
            this.container.getInputListener().setAllowedToConsumeInputEventFunction(allowedFunction);
        }
    }

    public static void initialize(Application application, String ... cssStyles) {
        INSTANCE = new JavaFxUI(application, installAdapter, cssStyles);
    }

    public static void setInstallAdapter(boolean installAdapter) {
        JavaFxUI.installAdapter = installAdapter;
    }

    public static JavaFxUI getInstance() {
        return INSTANCE;
    }

    public Group getGroup() {
        return this.group;
    }

    public Scene getScene() {
        return this.scene;
    }

    public void grabFocus() {
        this.container.grabFocus();
    }

    public void loseFocus() {
        this.container.loseFocus();
    }

    public void attachChild(Node node) {
        JfxPlatform.runInFxThread(() -> {
            this.uiscene.getChildren().add((Object)node);
            this.recursivelyNotifyChildrenAdded(node);
        });
    }

    public void detachChild(Node node) {
        JfxPlatform.runInFxThread(() -> {
            this.uiscene.getChildren().remove((Object)node);
            this.recursivelyNotifyChildrenRemoved(node);
        });
    }

    public void detachChild(String fxId) {
        JfxPlatform.runInFxThread(() -> {
            Node node = this.uiscene.lookup("#" + fxId);
            if (node != null) {
                this.uiscene.getChildren().remove((Object)node);
                this.recursivelyNotifyChildrenRemoved(node);
            }
        });
    }

    public Node getChild(String fxId) {
        return this.uiscene.lookup("#" + fxId);
    }

    public void removeAllChildren() {
        JfxPlatform.runInFxThread(() -> {
            ArrayList children = new ArrayList(this.uiscene.getChildren());
            this.uiscene.getChildren().clear();
            children.forEach(this::recursivelyNotifyChildrenRemoved);
        });
    }

    private void recursivelyNotifyChildrenRemoved(Node node) {
        boolean sceneNotifier = node instanceof SceneNotifier;
        boolean jmeUpdateLoop = node instanceof JmeUpdateLoop;
        if (sceneNotifier || jmeUpdateLoop) {
            this.app.enqueue(() -> {
                if (sceneNotifier) {
                    ((SceneNotifier)node).onDetached();
                }
                if (jmeUpdateLoop) {
                    this.updatingItems.remove(node);
                }
            });
        }
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            parent.getChildrenUnmodifiable().forEach(this::recursivelyNotifyChildrenRemoved);
        }
    }

    private void recursivelyNotifyChildrenAdded(Node node) {
        boolean sceneNotifier = node instanceof SceneNotifier;
        boolean jmeUpdateLoop = node instanceof JmeUpdateLoop;
        if (sceneNotifier || jmeUpdateLoop) {
            this.app.enqueue(() -> {
                if (sceneNotifier) {
                    ((SceneNotifier)node).onAttached(this.app);
                }
                if (jmeUpdateLoop) {
                    this.updatingItems.add((JmeUpdateLoop)node);
                }
            });
        }
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            parent.getChildrenUnmodifiable().forEach(this::recursivelyNotifyChildrenAdded);
        }
    }

    public void showDialog(Node node) {
        this.showDialog(node, true);
    }

    public void showDialog(Node node, boolean dimmed) {
        int scrWidth = this.app.getCamera().getWidth();
        int scrHeight = this.app.getCamera().getHeight();
        this.dialog = node;
        this.dialogBoundsListener = (prop, oldBounds, newBounds) -> {
            node.setLayoutX((double)scrWidth * 0.5 - newBounds.getWidth() * 0.5);
            node.setLayoutY((double)scrHeight * 0.5 - newBounds.getHeight() * 0.5);
        };
        if (this.dialog instanceof JmeUpdateLoop) {
            this.updatingItems.add((JmeUpdateLoop)this.dialog);
        }
        JfxPlatform.runInFxThread(() -> {
            this.dialogAnchorPanel.setStyle(null);
            this.dialogAnchorPanel.getChildren().add((Object)node);
            if (dimmed) {
                this.dialogAnchorPanel.setStyle("-fx-background-color:#000000AA");
            }
            this.uiscene.getChildren().add((Object)this.dialogAnchorPanel);
            node.boundsInParentProperty().addListener(this.dialogBoundsListener);
        });
    }

    public void removeDialog() {
        JfxPlatform.runInFxThread(() -> {
            this.dialogAnchorPanel.getChildren().clear();
            this.uiscene.getChildren().remove((Object)this.dialogAnchorPanel);
        });
        if (this.dialog instanceof JmeUpdateLoop) {
            this.updatingItems.remove(this.dialog);
        }
        this.dialog.boundsInParentProperty().removeListener(this.dialogBoundsListener);
        this.dialog = null;
        this.dialogBoundsListener = null;
    }

    public void runInJavaFxThread(Runnable task) {
        Platform.runLater((Runnable)task);
    }

    public void runInJmeThread(Runnable task) {
        this.app.enqueue(task);
    }

    public JmeFxContainer getJmeFxContainer() {
        return this.container;
    }

    static {
        installAdapter = true;
    }

    private class JavaFxUpdater
    extends BaseAppState {
        private Camera cam;

        private JavaFxUpdater() {
        }

        protected void initialize(Application app) {
            this.cam = app.getCamera();
        }

        protected void cleanup(Application app) {
        }

        protected void onEnable() {
        }

        protected void onDisable() {
        }

        public void update(float tpf) {
            if (JavaFxUI.this.camWidth != this.cam.getWidth() || JavaFxUI.this.camHeight != this.cam.getHeight()) {
                JavaFxUI.this.camWidth = this.cam.getWidth();
                JavaFxUI.this.camHeight = this.cam.getHeight();
            }
            if (JavaFxUI.this.container.isNeedWriteToJme()) {
                JavaFxUI.this.container.writeToJme();
            }
            JavaFxUI.this.updatingItems.forEach(item -> item.update(tpf));
        }
    }
}

