/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.testplan.instance.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.rpc.annotation.Exporter;
import io.tiklab.teston.testplan.instance.dao.TestPlanInstanceDao;
import io.tiklab.teston.testplan.instance.entity.TestPlanInstanceEntity;
import io.tiklab.teston.testplan.instance.model.TestPlanCaseInstanceBind;
import io.tiklab.teston.testplan.instance.model.TestPlanCaseInstanceBindQuery;
import io.tiklab.teston.testplan.instance.model.TestPlanInstance;
import io.tiklab.teston.testplan.instance.model.TestPlanInstanceQuery;
import io.tiklab.teston.testplan.instance.service.TestPlanCaseInstanceBindService;
import io.tiklab.teston.testplan.instance.service.TestPlanInstanceService;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Exporter
public class TestPlanInstanceServiceImpl
implements TestPlanInstanceService {
    @Autowired
    TestPlanInstanceDao testPlanInstanceDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    TestPlanCaseInstanceBindService testPlanCaseInstanceBindService;

    public String createTestPlanInstance(@NotNull @Valid TestPlanInstance testPlanInstance) {
        TestPlanInstanceEntity testPlanInstanceEntity = (TestPlanInstanceEntity)BeanMapper.map((Object)testPlanInstance, TestPlanInstanceEntity.class);
        return this.testPlanInstanceDao.createTestPlanInstance(testPlanInstanceEntity);
    }

    public void updateTestPlanInstance(@NotNull @Valid TestPlanInstance testPlanInstance) {
        TestPlanInstanceEntity testPlanInstanceEntity = (TestPlanInstanceEntity)BeanMapper.map((Object)testPlanInstance, TestPlanInstanceEntity.class);
        this.testPlanInstanceDao.updateTestPlanInstance(testPlanInstanceEntity);
    }

    public void deleteTestPlanInstance(@NotNull String id) {
        this.testPlanInstanceDao.deleteTestPlanInstance(id);
        TestPlanCaseInstanceBindQuery testPlanCaseInstanceBindQuery = new TestPlanCaseInstanceBindQuery();
        testPlanCaseInstanceBindQuery.setTestPlanInstanceId(id);
        List testPlanCaseInstanceBindList = this.testPlanCaseInstanceBindService.findTestPlanCaseInstanceBindList(testPlanCaseInstanceBindQuery);
        if (CollectionUtils.isNotEmpty((Collection)testPlanCaseInstanceBindList) && testPlanCaseInstanceBindList.size() > 0) {
            for (TestPlanCaseInstanceBind testPlanCaseInstanceBind : testPlanCaseInstanceBindList) {
                this.testPlanCaseInstanceBindService.deleteTestPlanCaseInstanceBind(testPlanCaseInstanceBind.getId());
            }
        }
    }

    public TestPlanInstance findOne(String id) {
        TestPlanInstanceEntity testPlanInstanceEntity = this.testPlanInstanceDao.findTestPlanInstance(id);
        TestPlanInstance testPlanInstance = (TestPlanInstance)BeanMapper.map((Object)testPlanInstanceEntity, TestPlanInstance.class);
        return testPlanInstance;
    }

    public List<TestPlanInstance> findList(List<String> idList) {
        List<TestPlanInstanceEntity> testPlanInstanceEntityList = this.testPlanInstanceDao.findTestPlanInstanceList(idList);
        List testPlanInstanceList = BeanMapper.mapList(testPlanInstanceEntityList, TestPlanInstance.class);
        return testPlanInstanceList;
    }

    public TestPlanInstance findTestPlanInstance(@NotNull String id) {
        TestPlanInstance testPlanInstance = this.findOne(id);
        this.joinTemplate.joinQuery((Object)testPlanInstance);
        return testPlanInstance;
    }

    public List<TestPlanInstance> findAllTestPlanInstance() {
        List<TestPlanInstanceEntity> testPlanInstanceEntityList = this.testPlanInstanceDao.findAllTestPlanInstance();
        List testPlanInstanceList = BeanMapper.mapList(testPlanInstanceEntityList, TestPlanInstance.class);
        this.joinTemplate.joinQuery(testPlanInstanceList);
        return testPlanInstanceList;
    }

    public List<TestPlanInstance> findTestPlanInstanceList(TestPlanInstanceQuery testPlanInstanceQuery) {
        List<TestPlanInstanceEntity> testPlanInstanceEntityList = this.testPlanInstanceDao.findTestPlanInstanceList(testPlanInstanceQuery);
        List testPlanInstanceList = BeanMapper.mapList(testPlanInstanceEntityList, TestPlanInstance.class);
        this.joinTemplate.joinQuery(testPlanInstanceList);
        return testPlanInstanceList;
    }

    public Pagination<TestPlanInstance> findTestPlanInstancePage(TestPlanInstanceQuery testPlanInstanceQuery) {
        Pagination<TestPlanInstanceEntity> pagination = this.testPlanInstanceDao.findTestPlanInstancePage(testPlanInstanceQuery);
        List testPlanInstanceList = BeanMapper.mapList((List)pagination.getDataList(), TestPlanInstance.class);
        this.joinTemplate.joinQuery(testPlanInstanceList);
        return PaginationBuilder.build(pagination, (List)testPlanInstanceList);
    }
}

