/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.testplan.execute.service;

import io.tiklab.eam.common.context.LoginContext;
import io.tiklab.rpc.annotation.Exporter;
import io.tiklab.teston.common.TestUtil;
import io.tiklab.teston.testplan.cases.model.TestPlanCase;
import io.tiklab.teston.testplan.cases.model.TestPlanCaseQuery;
import io.tiklab.teston.testplan.cases.service.TestPlanCaseService;
import io.tiklab.teston.testplan.execute.model.TestPlanTestData;
import io.tiklab.teston.testplan.execute.model.TestPlanTestResponse;
import io.tiklab.teston.testplan.execute.service.TestPlanExecuteApiDispatch;
import io.tiklab.teston.testplan.execute.service.TestPlanExecuteAppDispatch;
import io.tiklab.teston.testplan.execute.service.TestPlanExecuteDispatchService;
import io.tiklab.teston.testplan.execute.service.TestPlanExecuteWebDispatch;
import io.tiklab.teston.testplan.instance.model.TestPlanCaseInstanceBind;
import io.tiklab.teston.testplan.instance.model.TestPlanInstance;
import io.tiklab.teston.testplan.instance.model.TestPlanInstanceQuery;
import io.tiklab.teston.testplan.instance.service.TestPlanInstanceService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Exporter
public class TestPlanExecuteDispatchServiceImpl
implements TestPlanExecuteDispatchService {
    static Logger logger = LoggerFactory.getLogger(TestPlanExecuteDispatchServiceImpl.class);
    @Autowired
    TestPlanCaseService testPlanCaseService;
    @Autowired
    TestPlanExecuteApiDispatch testPlanExecuteApiDispatch;
    @Autowired
    TestPlanExecuteWebDispatch testPlanExecuteWebDispatch;
    @Autowired
    TestPlanExecuteAppDispatch testPlanExecuteAppDispatch;
    @Autowired
    TestUtil testUtil;
    @Autowired
    TestPlanInstanceService testPlanInstanceService;
    private ArrayList<TestPlanCaseInstanceBind> testPlanCaseInstanceList = new ArrayList();
    private String testPlanId;
    private Integer exeCount = 0;
    private Integer apiPerfCount = 0;
    private Integer webPerfCount = 0;
    private Integer appPerfCount = 0;
    public String testPlanInstanceId;
    private Integer status = 0;

    public void execute(TestPlanTestData testPlanTestData) {
        this.exeCount = 0;
        this.apiPerfCount = 0;
        this.webPerfCount = 0;
        this.appPerfCount = 0;
        this.testPlanCaseInstanceList.clear();
        this.status = 1;
        this.testPlanId = testPlanTestData.getTestPlanId();
        String repositoryId = testPlanTestData.getRepositoryId();
        TestPlanInstance testPlanInstance = new TestPlanInstance();
        TestPlanInstanceQuery testPlanInstanceQuery = new TestPlanInstanceQuery();
        testPlanInstanceQuery.setRepositoryId(testPlanTestData.getRepositoryId());
        List testPlanInstanceList = this.testPlanInstanceService.findTestPlanInstanceList(testPlanInstanceQuery);
        if (testPlanInstanceList.size() > 0) {
            Integer executeNumber = ((TestPlanInstance)testPlanInstanceList.get(0)).getExecuteNumber();
            Integer addNumber = executeNumber + 1;
            testPlanInstance.setExecuteNumber(addNumber);
        } else {
            testPlanInstance.setExecuteNumber(Integer.valueOf(1));
        }
        testPlanInstance.setTestPlanId(this.testPlanId);
        testPlanInstance.setRepositoryId(repositoryId);
        testPlanInstance.setCreateTime(new Timestamp(System.currentTimeMillis()));
        testPlanInstance.setCreateUser(LoginContext.getLoginId());
        this.testPlanInstanceId = this.testPlanInstanceService.createTestPlanInstance(testPlanInstance);
        TestPlanCaseQuery testPlanCaseQuery = new TestPlanCaseQuery();
        testPlanCaseQuery.setTestPlanId(this.testPlanId);
        List testPlanCaseList = this.testPlanCaseService.findTestPlanCaseList(testPlanCaseQuery);
        if (CollectionUtils.isNotEmpty((Collection)testPlanCaseList)) {
            String testType;
            for (TestPlanCase testPlanCase : testPlanCaseList) {
                testType = testPlanCase.getTestCase().getTestType();
                if (!Objects.equals(testType, "api") && !Objects.equals(testType, "perform")) continue;
                Integer n = this.exeCount;
                this.exeCount = this.exeCount + 1;
            }
            for (TestPlanCase testPlanCase : testPlanCaseList) {
                testType = testPlanCase.getTestCase().getTestType();
                String caseType = testPlanCase.getTestCase().getCaseType();
                if (!Objects.equals(testType, "api") && !Objects.equals(testType, "perform")) continue;
                switch (caseType) {
                    case "api-unit": {
                        TestPlanCaseInstanceBind testPlanCaseInstanceBind = this.testPlanExecuteApiDispatch.exeApiUnit(testPlanCase, testPlanTestData, this.testPlanInstanceId);
                        this.testPlanCaseInstanceList.add(testPlanCaseInstanceBind);
                        break;
                    }
                    case "api-scene": {
                        Integer apiSceneInstance = this.testPlanExecuteApiDispatch.exeApiScene(testPlanCase, testPlanTestData, this.testPlanInstanceId);
                        this.testPlanCaseInstanceList.add((TestPlanCaseInstanceBind)apiSceneInstance);
                        break;
                    }
                    case "api-perform": {
                        Integer apiSceneInstance = this.apiPerfCount;
                        this.apiPerfCount = this.apiPerfCount + 1;
                        this.testPlanExecuteApiDispatch.exeApiPerform(testPlanCase, testPlanTestData, this.testPlanInstanceId);
                        break;
                    }
                    case "web-scene": {
                        Integer webSceneInstance = this.testPlanExecuteWebDispatch.exeWebScene(testPlanCase, testPlanTestData, this.testPlanInstanceId);
                        this.testPlanCaseInstanceList.add((TestPlanCaseInstanceBind)webSceneInstance);
                        break;
                    }
                    case "web-perform": {
                        Integer webSceneInstance = this.webPerfCount;
                        this.webPerfCount = this.webPerfCount + 1;
                        this.testPlanExecuteWebDispatch.exeWebPerform(testPlanCase, testPlanTestData, this.testPlanInstanceId);
                        break;
                    }
                    case "app-scene": {
                        TestPlanCaseInstanceBind appSceneInstance = this.testPlanExecuteAppDispatch.exeAppScene(testPlanCase, testPlanTestData, this.testPlanInstanceId);
                        this.testPlanCaseInstanceList.add(appSceneInstance);
                        break;
                    }
                    case "app-perform": {
                        Integer n = this.appPerfCount;
                        this.appPerfCount = this.appPerfCount + 1;
                        this.testPlanExecuteAppDispatch.exeAppPerform(testPlanCase, testPlanTestData, this.testPlanInstanceId);
                        break;
                    }
                }
            }
        }
    }

    public TestPlanTestResponse exeResult() {
        TestPlanTestResponse testPlanTestResponse = new TestPlanTestResponse();
        TestPlanInstance testPlanInstance = this.processInstance(this.testPlanCaseInstanceList);
        testPlanTestResponse.setTestPlanInstance(testPlanInstance);
        testPlanTestResponse.setTestPlanCaseInstanceList(this.testPlanCaseInstanceList);
        if (this.apiPerfCount != 0 && this.testPlanExecuteApiDispatch.apiPerfStatus == 1) {
            TestPlanCaseInstanceBind apiPerfInstance = this.testPlanExecuteApiDispatch.apiPerfResult();
            this.testPlanCaseInstanceList.add(apiPerfInstance);
        }
        if (Objects.equals(this.testPlanCaseInstanceList.size(), this.exeCount)) {
            this.status = 0;
            testPlanTestResponse.setStatus(this.status);
        } else {
            this.status = 1;
            testPlanTestResponse.setStatus(this.status);
        }
        this.saveToSql(testPlanInstance);
        return testPlanTestResponse;
    }

    private TestPlanInstance processInstance(ArrayList<TestPlanCaseInstanceBind> testPlanCaseInstanceList) {
        TestPlanInstance testPlanInstance = new TestPlanInstance();
        int total = this.exeCount;
        testPlanInstance.setTotal(Integer.valueOf(total));
        int passNum = 0;
        for (TestPlanCaseInstanceBind testPlanCaseInstance : testPlanCaseInstanceList) {
            if (!Objects.equals(testPlanCaseInstance.getResult(), 1)) continue;
            ++passNum;
        }
        String passRate = this.testUtil.processRate(passNum, total);
        testPlanInstance.setPassNum(Integer.valueOf(passNum));
        testPlanInstance.setPassRate(passRate);
        testPlanInstance.setFailNum(Integer.valueOf(total - passNum));
        String errorRate = this.testUtil.processRate(total - passNum, total);
        testPlanInstance.setErrorRate(errorRate);
        if (Objects.equals(total, passNum)) {
            testPlanInstance.setResult(Integer.valueOf(1));
        } else {
            testPlanInstance.setResult(Integer.valueOf(0));
        }
        return testPlanInstance;
    }

    private void saveToSql(TestPlanInstance testPlanInstance) {
        testPlanInstance.setTestPlanId(this.testPlanId);
        testPlanInstance.setId(this.testPlanInstanceId);
        this.testPlanInstanceService.updateTestPlanInstance(testPlanInstance);
    }
}

