/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.testplan.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.rpc.annotation.Exporter;
import io.tiklab.teston.testplan.cases.dao.TestPlanCaseDao;
import io.tiklab.teston.testplan.cases.dao.TestPlanDao;
import io.tiklab.teston.testplan.cases.entity.TestPlanCaseEntity;
import io.tiklab.teston.testplan.cases.entity.TestPlanEntity;
import io.tiklab.teston.testplan.cases.model.TestPlan;
import io.tiklab.teston.testplan.cases.model.TestPlanCaseQuery;
import io.tiklab.teston.testplan.cases.model.TestPlanQuery;
import io.tiklab.teston.testplan.cases.service.TestPlanService;
import java.sql.Timestamp;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Exporter
public class TestPlanServiceImpl
implements TestPlanService {
    @Autowired
    TestPlanDao testPlanDao;
    @Autowired
    TestPlanCaseDao testPlanCaseDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createTestPlan(@NotNull @Valid TestPlan testPlan) {
        TestPlanEntity testPlanEntity = (TestPlanEntity)BeanMapper.map((Object)testPlan, TestPlanEntity.class);
        testPlanEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        testPlanEntity.setState(0);
        return this.testPlanDao.createTestPlan(testPlanEntity);
    }

    public void updateTestPlan(@NotNull @Valid TestPlan testPlan) {
        TestPlanEntity testPlanEntity = (TestPlanEntity)BeanMapper.map((Object)testPlan, TestPlanEntity.class);
        testPlanEntity.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        this.testPlanDao.updateTestPlan(testPlanEntity);
    }

    public void deleteTestPlan(@NotNull String id) {
        this.testPlanDao.deleteTestPlan(id);
    }

    public TestPlan findOne(String id) {
        TestPlanEntity testPlanEntity = this.testPlanDao.findTestPlan(id);
        TestPlan testPlan = (TestPlan)BeanMapper.map((Object)testPlanEntity, TestPlan.class);
        return testPlan;
    }

    public List<TestPlan> findList(List<String> idList) {
        List<TestPlanEntity> testPlanEntityList = this.testPlanDao.findTestPlanList(idList);
        List testPlanList = BeanMapper.mapList(testPlanEntityList, TestPlan.class);
        return testPlanList;
    }

    public TestPlan findTestPlan(@NotNull String id) {
        TestPlan testPlan = this.findOne(id);
        this.joinTemplate.joinQuery((Object)testPlan);
        return testPlan;
    }

    public List<TestPlan> findAllTestPlan() {
        List<TestPlanEntity> testPlanEntityList = this.testPlanDao.findAllTestPlan();
        List testPlanList = BeanMapper.mapList(testPlanEntityList, TestPlan.class);
        this.joinTemplate.joinQuery(testPlanList);
        return testPlanList;
    }

    public List<TestPlan> findTestPlanList(TestPlanQuery testPlanQuery) {
        List<TestPlanEntity> testPlanEntityList = this.testPlanDao.findTestPlanList(testPlanQuery);
        List testPlanList = BeanMapper.mapList(testPlanEntityList, TestPlan.class);
        this.joinTemplate.joinQuery(testPlanList);
        return testPlanList;
    }

    public Pagination<TestPlan> findTestPlanPage(TestPlanQuery testPlanQuery) {
        Pagination<TestPlanEntity> pagination = this.testPlanDao.findTestPlanPage(testPlanQuery);
        List testPlanList = BeanMapper.mapList((List)pagination.getDataList(), TestPlan.class);
        for (TestPlan testPlan : testPlanList) {
            List<TestPlanCaseEntity> testPlanDetailList = this.testPlanCaseDao.findTestPlanCaseList(new TestPlanCaseQuery().setTestPlanId(testPlan.getId()));
            if (CollectionUtils.isNotEmpty(testPlanDetailList)) {
                testPlan.setTestCaseNum(Integer.valueOf(testPlanDetailList.size()));
                continue;
            }
            testPlan.setTestCaseNum(Integer.valueOf(0));
        }
        this.joinTemplate.joinQuery(testPlanList);
        return PaginationBuilder.build(pagination, (List)testPlanList);
    }
}

