/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.testplan.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.category.service.CategoryService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import io.tiklab.teston.testplan.cases.dao.TestPlanCaseDao;
import io.tiklab.teston.testplan.cases.entity.TestPlanCaseEntity;
import io.tiklab.teston.testplan.cases.model.TestPlanCase;
import io.tiklab.teston.testplan.cases.model.TestPlanCaseQuery;
import io.tiklab.teston.testplan.cases.service.TestPlanCaseService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestPlanCaseServiceImpl
implements TestPlanCaseService {
    @Autowired
    TestPlanCaseDao testPlanDetailDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    CategoryService categoryService;

    public String createTestPlanCase(@NotNull @Valid TestPlanCase testPlanCase) {
        TestPlanCaseEntity testPlanCaseEntity = (TestPlanCaseEntity)BeanMapper.map((Object)testPlanCase, TestPlanCaseEntity.class);
        testPlanCaseEntity.setStatus(2);
        return this.testPlanDetailDao.createTestPlanCase(testPlanCaseEntity);
    }

    public void updateTestPlanCase(@NotNull @Valid TestPlanCase testPlanCase) {
        TestPlanCaseEntity testPlanCaseEntity = (TestPlanCaseEntity)BeanMapper.map((Object)testPlanCase, TestPlanCaseEntity.class);
        this.testPlanDetailDao.updateTestPlanCase(testPlanCaseEntity);
    }

    public void deleteTestPlanCase(@NotNull String id) {
        this.testPlanDetailDao.deleteTestPlanCase(id);
    }

    public TestPlanCase findOne(String id) {
        TestPlanCaseEntity testPlanCaseEntity = this.testPlanDetailDao.findTestPlanCase(id);
        TestPlanCase testPlanCase = (TestPlanCase)BeanMapper.map((Object)testPlanCaseEntity, TestPlanCase.class);
        return testPlanCase;
    }

    public List<TestPlanCase> findList(List<String> idList) {
        List<TestPlanCaseEntity> testPlanCaseEntityList = this.testPlanDetailDao.findTestPlanCaseList(idList);
        List testPlanCaseList = BeanMapper.mapList(testPlanCaseEntityList, TestPlanCase.class);
        return testPlanCaseList;
    }

    public TestPlanCase findTestPlanCase(@NotNull String id) {
        TestPlanCase testPlanCase = this.findOne(id);
        this.joinTemplate.joinQuery((Object)testPlanCase);
        return testPlanCase;
    }

    public List<TestPlanCase> findAllTestPlanCase() {
        List<TestPlanCaseEntity> testPlanCaseEntityList = this.testPlanDetailDao.findAllTestPlanCase();
        List testPlanCaseList = BeanMapper.mapList(testPlanCaseEntityList, TestPlanCase.class);
        this.joinTemplate.joinQuery(testPlanCaseList);
        return testPlanCaseList;
    }

    public List<TestPlanCase> findTestPlanCaseList(TestPlanCaseQuery testPlanCaseQuery) {
        List<TestPlanCaseEntity> testPlanCaseEntityList = this.testPlanDetailDao.findTestPlanCaseList(testPlanCaseQuery);
        List testPlanCaseList = BeanMapper.mapList(testPlanCaseEntityList, TestPlanCase.class);
        this.joinTemplate.joinQuery(testPlanCaseList);
        return testPlanCaseList;
    }

    public Pagination<TestPlanCase> findTestPlanCasePage(TestPlanCaseQuery testPlanCaseQuery) {
        Pagination<TestPlanCaseEntity> pagination = this.testPlanDetailDao.findTestPlanCasePage(testPlanCaseQuery);
        List testPlanCaseList = BeanMapper.mapList((List)pagination.getDataList(), TestPlanCase.class);
        this.joinTemplate.joinQuery(testPlanCaseList);
        return PaginationBuilder.build(pagination, (List)testPlanCaseList);
    }

    public Pagination<TestCase> findTesCaseList(TestPlanCase testPlanCase) {
        TestCaseQuery testCaseQuery = new TestCaseQuery();
        testCaseQuery.setRepositoryId(testPlanCase.getRepositoryId());
        Pagination testCasePage = this.testCaseService.findTestCasePage(testCaseQuery);
        return testCasePage;
    }

    public Pagination<TestPlanCase> findBindTestCaseList(TestPlanCaseQuery testPlanCaseQuery) {
        Pagination<TestPlanCase> testPlanDetailPage = this.findTestPlanCasePage(testPlanCaseQuery);
        return testPlanDetailPage;
    }

    public void planBindCase(List<TestPlanCase> testPlanCaseList) {
        for (TestPlanCase testPlanCase : testPlanCaseList) {
            this.createTestPlanCase(testPlanCase);
        }
    }
}

