/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.testplan.cases.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.testplan.cases.entity.TestPlanEntity;
import io.tiklab.teston.testplan.cases.model.TestPlanQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TestPlanDao {
    private static Logger logger = LoggerFactory.getLogger(TestPlanDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createTestPlan(TestPlanEntity testPlanEntity) {
        return (String)this.jpaTemplate.save((Object)testPlanEntity, String.class);
    }

    public void updateTestPlan(TestPlanEntity testPlanEntity) {
        this.jpaTemplate.update((Object)testPlanEntity);
    }

    public void deleteTestPlan(String id) {
        this.jpaTemplate.delete(TestPlanEntity.class, (Object)id);
    }

    public void deleteTestPlan(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public TestPlanEntity findTestPlan(String id) {
        return (TestPlanEntity)this.jpaTemplate.findOne(TestPlanEntity.class, (Object)id);
    }

    public List<TestPlanEntity> findAllTestPlan() {
        return this.jpaTemplate.findAll(TestPlanEntity.class);
    }

    public List<TestPlanEntity> findTestPlanList(List<String> idList) {
        return this.jpaTemplate.findList(TestPlanEntity.class, idList);
    }

    public List<TestPlanEntity> findTestPlanList(TestPlanQuery testPlanQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(TestPlanEntity.class).eq("repositoryId", (Object)testPlanQuery.getRepositoryId()).eq("state", (Object)testPlanQuery.getState()).like("name", (Object)testPlanQuery.getName()).orders(testPlanQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, TestPlanEntity.class);
    }

    public Pagination<TestPlanEntity> findTestPlanPage(TestPlanQuery testPlanQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(TestPlanEntity.class).eq("repositoryId", (Object)testPlanQuery.getRepositoryId()).eq("state", (Object)testPlanQuery.getState()).like("name", (Object)testPlanQuery.getName()).orders(testPlanQuery.getOrderParams()).pagination(testPlanQuery.getPageParam()).get();
        return this.jpaTemplate.findPage(queryCondition, TestPlanEntity.class);
    }
}

